/* GMP3 - A front end for mpg123
 * Copyright (C) 1998 Brett Kosinski
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glib.h>
#include <stdio.h>
#include <stdlib.h>
#include "gmp3.h"
#include "listutils.h"

configType options;  /* Here to satisfy linker */

const char *albumnlist_id_string = "*gmp3_playlist*";
const char *new_albumnlist_id_string = "*gmp3_albumnlist*";
albumnNode *albumnList;

void loadAlbumns()
{
  albumnNode *currentAlbumn = NULL;
  songNode *currentSong = NULL;
  
  int stackPos = 0;
  char *name = (char *)malloc(255);
  char *title = (char *)malloc(255);
  char *tempBuffer = (gchar *)malloc(255);
  char buffer;
  
  fgets(tempBuffer, 255, stdin);
  tempBuffer[strlen(tempBuffer)-1] = '\0';
    
  if (strcmp(tempBuffer, albumnlist_id_string) != 0)
    return;
    
  while (!feof(stdin) && (stackPos >= 0))
    {
      buffer = fgetc(stdin);
      
      if (buffer == '\\')
        {          
          fgets(name, 255, stdin);
          if (name[0] == '\n')
            continue; 
        
          name[strlen(name)-1] = '\0';
          currentAlbumn = newAlbumn(name, albumnList);
          
          g_list_append(albumnList->albumns, currentAlbumn);
        }
      else if (currentAlbumn != NULL)
        {
          ungetc(buffer, stdin);
          fscanf(stdin, "%254[^ \n]", name);
          
          if (feof(stdin))
            continue;
            
          fgets(title, 255, stdin);
          if (strlen(title) > 0)
            {
              title[strlen(title)-1] = '\0';
              currentSong = newSong(name, &title[1], currentAlbumn);
            }
          else
            currentSong = newSong(name, NULL, currentAlbumn);
            
          g_list_append(currentAlbumn->songs, currentSong);
        }  
    }
}

void printAlbumns()
{
  GList *currentAlbumnNode;
  GList *currentSongNode;
  albumnNode *currentAlbumn;
  songNode *currentSong;  
 
  printf("%s\n", new_albumnlist_id_string);    
  printf("\\%s\n", albumnList->title);
  currentAlbumnNode = g_list_first(albumnList->albumns)->next;
  
  while (currentAlbumnNode)
    {
      currentAlbumn = (albumnNode *)(currentAlbumnNode->data);
      currentSongNode = g_list_first(currentAlbumn->songs)->next;
      
      printf("\\%s\n", currentAlbumn->title);
      
      while (currentSongNode)
        {
          currentSong = (songNode *)(currentSongNode->data);
          
          printf("%s\t%s\n", currentSong->fileName, currentSong->title);
          currentSongNode = currentSongNode->next;
        }
        
      printf("\\\n");      
      currentAlbumnNode = currentAlbumnNode->next;
    } 
    
  printf("\\\n");
}

int main(int argc, char *argv[])
{
  if (argc < 1)
    {
      printf("convert < inputfile > outputfile\n");
      return 0;
    }

  albumnList = newAlbumn(ROOTNAME, NULL);
  
  loadAlbumns();
  printAlbumns();    
  
  return 0;
}
