/* <<< Start of information >>>                                             */
/* This file is part of the xcolmix package.                                */
/* Copyright (C) 1996  Karel Kubat. All rights reserved.                    */
/*                                                                          */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/*                                                                          */
/* You may link this software with XForms (Copyright (C) by T.C. Zhao and   */
/* Mark Overmars) and distribute the resulting binary, under the            */
/* restrictions in clause 3 of the GPL, even though the resulting binary is */
/* not, as a whole, covered by the GPL. (You still need a separate license  */
/* to do so from the owner(s) of the copyright for XForms, however).  If a  */
/* derivative no longer requires XForms, you may use the unsupplemented GPL */
/* as its license by deleting this paragraph and therefore removing this    */
/* exemption for XForms.                                                    */
/*                                                                          */
/* This program is distributed in the hope that it will be useful,          */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/* GNU General Public License for more details.                             */
/*                                                                          */
/* You should have received a copy of the GNU General Public License        */
/* along with this program; if not, write to the Free Software              */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/* <<< End of information >>>                                               */

#include "xcolmix.h"

void cb_search (FL_OBJECT *ob, long data)
{
    char const
        *col = fl_get_input (ob);
    int
        i;
        
    if (! col || ! *col)
        return;
        
    for (i = fl_get_browser (lookup_browser) + 1; 
         i <= fl_get_browser_maxline (lookup_browser);
         i++)
    {
        if (strstr (fl_get_browser_line (lookup_browser, i), col))
        {
            fl_select_browser_line (lookup_browser, i);
            if (i > 1)
                fl_set_browser_topline (lookup_browser, i - 1);
            else
                fl_set_browser_topline (lookup_browser, 1);
            cb_selectcolor (lookup_browser, 0);
            return;
        }
    }
}

void cb_quit(FL_OBJECT *ob, long data)
{
    fl_finish ();
    exit (0);
}

void cb_red (FL_OBJECT *ob, long data)
{
    register int
	val = (int) fl_get_slider_value (ob);
    
    if (foreground_selected)
	fg_red = val;
    else
	bg_red = val;
    makecolor ();
}

void cb_green (FL_OBJECT *ob, long data)
{
    register int
	val = (int) fl_get_slider_value (ob);
    
    if (foreground_selected)
	fg_green = val;
    else
	bg_green = val;
    makecolor ();
}

void cb_blue (FL_OBJECT *ob, long data)
{
    register int
	val = (int) fl_get_slider_value (ob);
    
    if (foreground_selected)
	fg_blue = val;
    else
	bg_blue = val;
    makecolor ();
}

void cb_lookup (FL_OBJECT *ob, long data)
{
    if (! lookup_on_screen)
    {
	fl_set_form_position (lookup, 0, 0);
	fl_show_form (lookup, FL_PLACE_FREE, FL_FULLBORDER, "Color Lookup");
	lookup_on_screen = 1;
    }
}

void cb_selectcolor (FL_OBJECT *ob, long data)
{
    register int
	sel = fl_get_browser (ob);
    register char const
	*text;
    int
	r,
	g,
	b;

    if (! sel)
	return;
    text = fl_get_browser_line (ob, sel);
    if (sscanf (text, "%d %d %d", &r, &g, &b) < 3)
	return;
    
    if (foreground_selected)
    {
	fg_red = r;
	fg_green = g;
	fg_blue = b;
    }
    else
    {
	bg_red = r;
	bg_green = g;
	bg_blue = b;
    }

    makecolor ();
}

void cb_lookupdone (FL_OBJECT *ob, long data)
{
    fl_hide_form (lookup);
    lookup_on_screen = 0;
}

void cb_select_foreground (FL_OBJECT *ob, long data)
{
    foreground_selected = 1;
    fl_set_button (background_button, 0);
    fl_set_button (foreground_button, 1);

    makecolor ();
}

void cb_select_background (FL_OBJECT *ob, long data)
{
    foreground_selected = 0;
    fl_set_button (background_button, 1);
    fl_set_button (foreground_button, 0);

    makecolor ();
}

