/*
 * Copyright (c)1999 ASTEC, Inc.
 * Copyright (c)2000 Fumitoshi UKAI
 *
 * The user MUST handle this program under LGPL Version 2.1.
 *
 * $Id: ns-bogus-locale.c,v 1.1 1999/10/21 12:33:29 tshiozak Exp $
 *
 * wctomb() and wcstombs() are written by AoiMoe/ASTEC
 * mbtowc() and modification by Fumitoshi UKAI
 */

/* Original Written By AoiMoe. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <wchar.h>

#ifndef DPRINT
#define DPRINT (0)
#endif

#ifndef DPRINT_FULL
#define DPRINT_FULL (0)
#endif

#if DPRINT_FULL
#undef DPRINT
#define DPRINT (1)
#endif

int
mbtowc(wchar_t *pwc, const char *s, size_t n)
{
    static mbstate_t __no_r_state;

    int *s_ebp = *(int **)((char *)(&pwc) - sizeof(void (*)()) 
			   - sizeof(void *));
    char *retaddr = *(char **)((char *)(&pwc) - sizeof(void (*)()));
    char *retretaddr = *(char **)(s_ebp + 1);
    int r;

/*
 * stack:
 *          s_ebp
 *          retaddr - (in ValidateString())
 *          pwc - wchar_t *
 *          s   - char *
 *          n   - size_t
 *
 *          <caller local vars> (ValidateString)
 *
 * s_ebp:   s_ebp2
 *          retretaddr
 *          tf - XmTextFieldWidget			dest - wchar_t *
 *          s  - char *					src - char *
 *          is_wchar - Boolean				n - int
 *	   (in XmTextFieldSetString)		       (in mbstowcs)
 *          <caller local vars> 
 *
 * s_ebp2:   
 *         retretretaddr
 *         w - Widget
 *         value - char *
 */


/* XmTextFieldSetString() -> */
/* 
 * communicator: 
 * ValidateString() - 0x890b7f8
 *   0x890b908 call mbtowc()
 */

    extern void _XmTextFieldSetSel2();
    extern void XmTextFieldSetString();
    extern void XmTextFieldSetStringWcs();
    static char *psrc = NULL;
    static char saved_src[8];

    if ((char *)mbstowcs < retaddr 
	&& retaddr < (char *)wcstombs
	&& (void *)s_ebp[2] == NULL) {
	if ((!(psrc + 1 <= (char *)s_ebp[3] && (char *)s_ebp[3] <= psrc + 4))) {
#if DPRINT
	    printf("call mbtowc!?(from mbstowcs?) ret=%p retret=%p ebp=%p\n", retaddr, retretaddr, s_ebp);
	    printf(" dest=%p\n", (void *)s_ebp[2]);
	    printf(" src=%p<%s>\n", (void *)s_ebp[3], (char *)s_ebp[3]);
	    printf(" n=%d\n", s_ebp[4]);
#endif
	    strncpy(saved_src, (char *)s_ebp[3], 4);
	    saved_src[4] = '\0';
#if DPRINT
	    printf("saved_src=[%s]\n", saved_src);
#endif
	}
	psrc = (char *)s_ebp[3];
    }
    if ((char *)_XmTextFieldSetSel2 + 9000 < retaddr 
	&& retaddr < (char *)_XmTextFieldSetSel2 + 10000
	&& (char *)XmTextFieldSetString < retretaddr
	&& retretaddr < (char *)XmTextFieldSetStringWcs) {

	int *s_ebp2 = (int *)s_ebp[0];
	int *tf = (int *)s_ebp[2];
	wchar_t wc;

#if DPRINT
	printf("saved_src[%s] <=> s[%s]\n", saved_src, s);
#endif
	/* 
	 * compare againt saved_src, beause too short string
	 * will exactly same between ASCII and UCS-4... *sigh*
	 */
	if (strncmp(saved_src, s, 4) == 0) {
//	    saved_src[0] = '\0'; /* XXX - reset */
#if DPRINT
	    printf("matched saved_src, goto normal process\n");
#endif	    
	    goto normal;
	}
	wc = *(wchar_t*)s;
#if DPRINT
	printf("call mbtowc!?(from ValidateString?) ret=%p retret=%p ebp=%p\n", retaddr, retretaddr, s_ebp);
	printf(" pwc=%p char=%p, n=%d wc=0x%04x\n", pwc, s, n, wc);
	printf(" tf=%p\n", (void *)s_ebp[2]);
	printf(" val=%p<%s>\n", (void *)s_ebp[3], (char *)s_ebp[3]);
	printf(" iw=%d\n", s_ebp[4]);
	printf(" w=%p\n", (void *)s_ebp2[2]);
	printf(" value=%p<%s>\n", (void *)s_ebp2[3], (char *)s_ebp2[3]);
	printf("s=%d w=%d\n", strlen(s), wcslen(s) * sizeof(wchar_t));
#endif
	*pwc = wc;
	if (s == (char *)s_ebp[3] && s_ebp[4] == 0 &&
	    strlen(s) <= 4 && sizeof(wchar_t) <= wcslen(s) * sizeof(wchar_t)) {
	    s_ebp[4] = 1; /* use_wchar = 1; */

	    /*
	     * XXX 
	     * Appearently, s points wide character string, not
	     * multibyte string.
	     * change return address to try again ValidateString
	     * (after stackframe setup at 0x890b801)
	     * with use_wchar = 1
	     *
	     */
	    *(int *)((char *)(&pwc) - sizeof(void (*)())) -= 0x10c;
#if DPRINT
	    printf("try again ValidateString with use_wchar=1\n");
#endif
	    return 0;

	}
	return sizeof(wchar_t);
    }
 normal:
#if DPRINT_FULL
    printf("mbtowc:");
    printf("pwc=%p char=%p<%s>, n=%d ", pwc, s, s, n);
#endif
    memset(&__no_r_state, 0, sizeof(__no_r_state));
    r = mbrtowc(pwc, s, n, &__no_r_state);
#if DPRINT_FULL
    printf("=>return=%d\n", r);
#endif
    return r;
}

int
wctomb(char *mb, wchar_t wc)
{
    static mbstate_t state;
    char *retaddr = *(char **)((char *)(&mb) - sizeof(void (*)()));

    int ret = 0;
    int flBroken = 0;

    if ( !mb ) {
        /* initialize of global state */
        memset(&state, 0, sizeof(state));
        return 0;
    }

    /* detect of broken MB_LEN_MAX */
    {

        /*
         * user action : paste into any "<textarea>" field.
         *      result : bus error.
         */
        {
            char *target_begin, *target_end;
            extern void _XmTextFieldCountBytes();
            extern void _XmTextFieldGetDropReciever();
            
            target_begin = (char *)&_XmTextFieldCountBytes;
            target_end = target_begin+0x100;

            if ( target_begin<retaddr && retaddr<target_end ) {
#if DPRINT
                fprintf(stderr,
                        "broken wctomb call detected :\n");
                fprintf(stderr,
                        "  retaddr=0x%08X, "
                        "_XmTextFieldCountBytes=0x%08X\n",
                        retaddr, (void *)&_XmTextFieldCountBytes);
#endif
                flBroken = -1;
            }
#if DPRINT_FULL
            else
                fprintf(stderr,
                        "wctomb  : retaddr=0x%08X, "
                        "_XmTextFieldCountBytes=0x%08X\n",
                        retaddr, (void *)&_XmTextFieldCountBytes);
#endif
        }

        /*
         * user action : double click on any "<input type=text>" field,
         *               to select a word.
         *      result : bus error.
         */
        {
            char *target_begin, *target_end;
            extern void _XmTextFieldSetDestination();

            target_begin = (char *)&_XmTextFieldSetDestination;
            target_end = target_begin+0x200;

            if ( target_begin<retaddr && retaddr<target_end ) {
#if DPRINT
                fprintf(stderr,
                        "broken wctomb call detected :\n");
                fprintf(stderr,
                        "  retaddr=0x%08X, "
                        "_XmTextFieldSetDestination=0x%08X\n",
                        retaddr, (void *)&_XmTextFieldSetDestination);
#endif
                flBroken = -1;
            }
#if DPRINT_FULL
            else
                fprintf(stderr,
                        "wctomb  : retaddr=0x%08X, "
                        "_XmTextFieldSetDestination=0x%08X\n",
                        retaddr, (void *)&_XmTextFieldSetDestination);
#endif
        }

    }
#if DPRINT_FULL
    fprintf(stderr, "wctomb: mb=%p, 0x%04x<%c> raddr=%p",
	    mb, wc, wc, retaddr);
#endif
    if ( flBroken ) {
        char tmp[6];
        ret = wcrtomb(tmp, wc, &state);
        *mb = tmp[0];
    } else
        ret = wcrtomb(mb, wc, &state);
    
    if (retaddr >= 0x40000000 && ret < 0) {
	/* wc is not recognized as wchar */
	if ((wc & 0x80) == 0) {
	    /* assume ASCII? */
	    *mb = (wc & 0xFF);
#if DPRINT_FULL
	    fprintf(stderr, "r=%d[wc is mb? <%c>]", ret, *mb);
#endif
	    ret = 1;
	}
    }
#if DPRINT_FULL
    fprintf(stderr, "=>ret=%d\n", ret);
#endif
    return ret;
}


#ifdef UNDER_46
size_t
wcstombs(char *mbs, wchar_t const *wcs, size_t n)
{
    static mbstate_t state;

    int ret = 0;
    int flBroken = 0;

    /*
     * user action : store initial value for "<textarea>" field in any way.
     *      result : put many waring messages.
     */

#if 0
/* XXX : It seems not needed and not enough. */
/*
    {
        char *retaddr;
        
        retaddr = *(char **)((char *)(&mbs) - sizeof(void (*)()));
        
        {
            char *target_begin, *target_end;
            extern void XmTextFieldGetString();
            
            target_end = (char *)&XmTextFieldGetString;
            target_begin = target_end-0xa000;

            if ( target_begin<retaddr && retaddr<target_end ) {
#if DPRINT
                fprintf(stderr, "illegal mbstowcs call detected :\n");
                fprintf(stderr,
                        "  retaddr=0x%08X, "
                        "XmTextFieldGetString=0x%08X\n",
                        retaddr, (void *)&XmTextFieldGetString);
                flBroken = -1;
#endif
            }
#if DPRINT_FULL
            else
                fprintf(stderr,
                        "wcstombs : retaddr=0x%08X, "
                        "XmTextFieldGetString=0x%08X\n",
                        retaddr, (void *)&XmTextFieldGetString);
#endif
        }
    }
*/
#endif

#if 1
    /* It seems the best way.... */
    if ( *wcs&0xffff0000 )
        flBroken = -1;
#endif

    if ( flBroken ) {
        strncpy(mbs, (char *)wcs, n);
        ret = strlen((char *)wcs);
        ret = (ret<n)?ret:n;
    } else {
        /* valid rune */
        ret = wcsrtombs(mbs, &wcs, n, &state);
    }

    return ret;
}
#endif /* UNDER_46 */


/* end of file */
