/*
 * loader/background.S
 *
 * Routine to load Choose-OS background file from disk to video memory.
 *
 * Copyright (c) Tuomo Valkonen 1997-1998.
 */

load_background:
	mov	ax,#0x3	// clear screen ;)
	int	#0x10
	
#ifdef BUG_HARDWARE
	// !!! Some hardware configurations bug and display noise when 
	// loaded directly disk -> video memory !!!
	// 0x1000 should be safe
        mov	bx,#0x1000
#else
	mov	bx,#0xb800
#endif
	mov	es,bx
	xor	bx,bx
	mov	cl,chos_bg_drive
	mov	si,#chos_bg_sects
	mov	secno,#8
	call	load_sects

#ifdef BUG_HARDWARE
	// now copy it to 0xb800
	push	ds
	mov	ax,#0x1000
	mov	ds,ax
	mov	ax,#0xb800
	mov	es,ax
	xor	si,si
	xor	di,di
	mov	cx,#2000
	cld
	rep
	movsw	
	pop	ds
#endif
	ret
	
