
#include <std.h>

#ifdef HAVE_LIBGPM

#include <list/screens.h>
#include <interface/coreui.h>
#include <interface/dialogs.h>
#include <interface/menu.h>

#include <gpm.h>

int gpm_user_handler(Gpm_Event * event, void *data)
{
	do
	{
		GPM_DRAWPOINTER(event);

		if (active_dialog != 0)
		{
			return active_dialog->gpm_handler(event);
		}
		else if (Gpm_StrictSingle(event->type))
		{
			if (event->y == 0 || event->y == 1)
			{
				if (event->x >= 0 && event->x <= ((COLS / 6) * 1))
					MenuDrop d(MenuDrop::M_Functions);
				else if (event->x > ((COLS / 6) * 1) && event->x <= ((COLS / 6) * 2))
					MenuDrop d(MenuDrop::M_Movement);
				else if (event->x > ((COLS / 6) * 2) && event->x <= ((COLS / 6) * 3))
					MenuDrop d(MenuDrop::M_Toggles);
				else if (event->x > ((COLS / 6) * 3) && event->x <= ((COLS / 6) * 4))
					MenuDrop d(MenuDrop::M_Modifiers);
				else if (event->x > ((COLS / 6) * 4) && event->x <= ((COLS / 6) * 5))
					MenuDrop d(MenuDrop::M_Filters);
				else if (event->x > ((COLS / 6) * 5) && event->x <= COLS)
					MenuDrop d(MenuDrop::M_Sorting);

				ui_refresh_current();
			}
			else if (event->y >= 3 && event->y <= MAIN_LINES + 2)
			{
				screen->_cursor = screen->_boundstart + event->y - 3;
				screen.boundreset(screen.Current());
				ui_redraw_current();
			}
		}

		/*printf
		   ("mouse: %s, at %2i,%2i (delta %2i,%2i), butt %i, mod %02X\r\n",
		   event->type & GPM_DOWN ? "press  " : (event->type & GPM_UP ?
		   "release" : "motion "), event->x, event->y,
		   event->dx, event->dy, event->buttons,
		   event->modifiers); */

		event->dx = event->dy = 0;	/* prepare for repetitions */
		if (event->type & GPM_DOWN)
			event->type = GPM_DRAG;

	}
	while ((event->type & GPM_DRAG) && Gpm_Repeat(200));

	return 0;

}

void gpm_open()
{
	Gpm_Connect conn;

	/* build a catch-all connectionData */

	conn.eventMask = ~0;
	conn.defaultMask = 0;
	conn.maxMod = ~0;
	conn.minMod = 0;

	if (Gpm_Open(&conn, 0) == -1)
	{
		fprintf(stderr, "Can't open mouse connection (GPM).\r\n");
		fflush(stderr);
		//exit(1);
	}			/*if */

	gpm_handler = gpm_user_handler;
}

void gpm_close()
{
	Gpm_Close();
}

#endif
