
#ifndef _ui_H
#define _ui_H

#include <stdarg.h>

extern WINDOW *wtop;
extern WINDOW *wmain;
extern WINDOW *wstat;
extern WINDOW *wdesc;
extern WINDOW *wdtop;

extern int TOP_LINES;
extern int STAT_LINES;
extern int MAIN_LINES;
extern int DTOP_LINES;
extern int DESC_LINES;

extern vector < string > *curDescLines;
extern int desc_width, desc_bound_start, desc_bound_end;

extern void ui_reset_bounds();
extern void ui_recalibrate();
extern void ui_redraw_main();
extern void ui_redraw_current();
extern void ui_refresh_current();
extern void ui_redraw_line();
extern void ui_scroll_up();
extern void ui_scroll_down();
extern void ui_draw_next_screen();
extern void ui_draw_prev_screen();
extern void ui_page_up();
extern void ui_page_down();
extern void ui_arrow_up();
extern void ui_arrow_down();
extern void ui_seek_end();
extern void ui_seek_start();
extern void ui_first_init();
extern void ui_initwindows();
extern void ui_finishwindows();
extern void ui_full_cleanup();
extern void ui_resize(int);
extern void ui_textentry(char *, char **);
extern void ui_DisplayPackage();
extern void ui_seek_nextmatched();
extern void ui_desc_window_show();
extern void ui_desc_window_hide();
extern void ui_scroll_descwin_up();
extern void ui_scroll_descwin_down();
extern void ui_divider_next();
extern void ui_divider_prev();

extern void ui_search_entry(char **, unsigned long *);
extern int ui_search_prompt(unsigned long, char *);
extern void ui_search_help();

#endif /* ui_H */
