
#include <std.h>

#include <list/packages.h>

#include <func/config.h>

#include "screens.h"

#include <interface/coreui.h>
#include <interface/dialogs.h>

ScreenList screen;

// Begin "ScreenList" class functions

ScreenList::ScreenList()
{
	_head = _current = NULL;
	filtnorm = filtinv = markstat = NULL;
}

ScreenList::~ScreenList()
{
	Screen *x, *y;

	for (x = _head; x != NULL; x = y)
	{
		y = x->next;
		remove(x);
	}
}

ScreenList::Screen * ScreenList::add(init_t Op = PkgInit)
{
	Screen *p;

	if (_current == NULL)
	{
		_current = (Screen *) malloc(sizeof(Screen));
		memset(_current, 0, sizeof(Screen));
		_current->next = NULL;
		_current->prev = NULL;
		_head = _current;
	}
	else
	{
		p = _current->next;
		_current->next = (Screen *) malloc(sizeof(Screen));
		memset(_current->next, 0, sizeof(Screen));
		_current->next->next = p;
		_current->next->prev = _current;
		_current = _current->next;
	}

	_current->kdriver = new KeyHandler(DefaultKeys::Bindings);
	_current->Sorting = new sortorderlist;

	// This needs to be dynamic.
	_current->Sorting->copy_from_config();

	if (Op == PkgInit)
		_current->Packages = new PackageList;

	if (strcmp(get_config_string("view"), "verbose") == 0)
		_current->mode = Verbose;
	else
		_current->mode = Normal;

	_current->scroll = 0;
	_current->_boundstart = 0;
	_current->_boundend = MAIN_LINES - 1;
	_current->_cursor = 0;

	return _current;
}

void ScreenList::remove(Screen * s)
{
	ScreenList::Screen * x, *y;

	delete s->kdriver;
	delete s->Packages;
	delete s->Sorting;

	x = s->next;
	y = s->prev;

	free(s);

	if (x != NULL)
		x->prev = y;
	if (y != NULL)
		y->next = x;
}

// Realign screen boundaries
//
void ScreenList::boundreset(Screen * S)
{
	PackageList::Package * P = S->Packages->Head();
	int I = 0;

//      ui_dialog(0, "pre-boundreset", "boundstart = %d, boundend = %d, cursor = %d, list length = %d", S->_boundstart, S->_boundend, S->_cursor, S->Packages->Length());

	if (S->Packages->Length() <= MAIN_LINES)
	{
		S->_boundstart = 0;
		S->_boundend = S->Packages->Length() - 1;
	}
	else
	{
		while (S->_boundend >= S->Packages->Length())
		{
			S->_boundend--;
			S->_boundstart--;
		}

		if (S->_boundstart < 0)
			S->_boundstart = 0;

		if ((S->_boundend - S->_boundstart) < MAIN_LINES)
			S->_boundend = S->_boundstart + MAIN_LINES - 1;
	}

	if (S->_cursor > S->_boundend)
	{
		S->_cursor = S->_boundend;
	}

	while (I < S->_boundstart)
	{
		P = P->next;
		I++;
	}

	S->boundstart = P;

	while (I < S->_cursor)
	{
		P = P->next;
		I++;
	}

	S->Cursor = P;

	while (I < S->_boundend)
	{
		P = P->next;
		I++;
	}

	S->boundend = P;

//      ui_dialog(0, "post-boundreset", "boundstart = %d, boundend = %d, cursor = %d, list length = %d", S->_boundstart, S->_boundend, S->_cursor, S->Packages->Length());
}

void ScreenList::align_all_bounds()
{
	for (Screen * S = _head; S != NULL; S = S->next)
		boundreset(S);
}
