
#include <std.h>
#include <list/colors.h>

void ColorMVPrintW(WINDOW * win, int pos_y, int pos_x, short defaultbackcolor, int attrs, char *fmt, ...)
{
	char *x, *y;
	short forecolor, backcolor = defaultbackcolor, oldcolor;
	va_list va;
	attr_t newattrs = 0, oldattrs;

	wattr_get(win, &oldattrs, &oldcolor, NULL);

	char BUF[768];

	va_start(va, fmt);
	vsnprintf(BUF, 767, fmt, va);
	va_end(va);

	wmove(win, pos_y, pos_x);

	for (x = BUF; *x != 0; x++)
	{
		if (*x == '$')
		{
			x++;

			switch (*x)
			{
			case '$':
				break;

			case '!':
				x++;
				wattrset(win, oldattrs);
				break;

			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':

				y = x;

				x++;

				if (*x == '/')
				{
					x++;

					switch (*x)
					{
					case '0':
						backcolor = COLOR_BLACK;
						break;
					case '1':
						backcolor = COLOR_RED;
						break;
					case '2':
						backcolor = COLOR_GREEN;
						break;
					case '3':
						backcolor = COLOR_YELLOW;
						break;
					case '4':
						backcolor = COLOR_BLUE;
						break;
					case '5':
						backcolor = COLOR_MAGENTA;
						break;
					case '6':
						backcolor = COLOR_CYAN;
						break;
					case '7':
						backcolor = COLOR_WHITE;
						break;
					}

					x++;
				}

				if (*x == '#')
				{
					newattrs = A_BOLD;
					x++;
				}
				else
					newattrs = 0;

				x--;

				switch (*y)
				{
				case '0':
					forecolor = COLOR_BLACK;
					break;
				case '1':
					forecolor = COLOR_RED;
					break;
				case '2':
					forecolor = COLOR_GREEN;
					break;
				case '3':
					forecolor = COLOR_YELLOW;
					break;
				case '4':
					forecolor = COLOR_BLUE;
					break;
				case '5':
					forecolor = COLOR_MAGENTA;
					break;
				case '6':
					forecolor = COLOR_CYAN;
					break;
				case '7':
					forecolor = COLOR_WHITE;
					break;
				default:
					goto InvalidColor;
				}
				wattrset(win, Pair(forecolor, backcolor) | newattrs | attrs);
			      InvalidColor:
				continue;

			}
		}

		wprintw(win, "%c", *x);
	}

	wattrset(win, oldattrs);
}

int ColorCountStrLen(char *Text)
{
	char *x, *y;

	int length = 0;

	for (x = Text; *x != 0; x++)
	{
		if (*x == '$')
		{
			x++;

			switch (*x)
			{
			case '$':
				x++;
				break;

			case '!':
				x++;
				break;

			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':

				y = x;

				x++;

				if (*x == '/')
				{
					x++;

					switch (*x)
					{
					case '0':
					case '1':
					case '2':
					case '3':
					case '4':
					case '5':
					case '6':
					case '7':
						break;
					}

					x++;
				}

				if (*x == '#')
					x++;

				x--;

				continue;
			}
		}
		length++;
	}

	return length;

}
