
#include <std.h>

/*
 * Remember to free this memory
 */
char *period_string(const char *string, unsigned count)
{
	char *Newstr = new char[count + 1];

	unsigned int I;

	for (I = 0; I < count; I++)
		Newstr[I] = string[I];

	Newstr[I] = 0;

	return Newstr;
}

void strlower(char *str)
{
	char *p;
	for (p = str; *p != '\0'; p++)
		*p = tolower(*p);
}

char *sane_strtok(char *s, const char *delim)
{
	static char *_s;

	if (s != NULL)
		_s = s;

	if (_s == NULL)
		return NULL;

	char *p;

	if ((p = strstr(_s, delim)) == NULL)
	{
		p = _s;
		_s = NULL;
		return p;
	}

	char *x = _s;

	*p = 0;
	_s = ++p;

	return x;
}

/*
 * Assuming dest has enough memory to hold len bytes of src
 */
void sane_strntrnc(char *dest, const char *src, unsigned int len)
{
	if (strlen(src) < len)
	{
		memcpy(dest, src, strlen(src));
		dest[strlen(src)] = 0;
	}
	else
	{
		memcpy(dest, src, len);
		dest[len] = 0;
	}
}
