/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *   Gnome Apt frontend
 *
 *   Copyright (C) 1998 Havoc Pennington <hp@pobox.com>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "dialogprogress.h"   

void 
OpDialogProgress::Update()
{
   if (CheckChange() == false)
      return;

   char s[300];
   
   if (MajorChange == true)
   {
     gtk_progress_set_activity_mode(GTK_PROGRESS(bar_), FALSE);
     gtk_label_set(GTK_LABEL(label_), Op.c_str());
   }
   
   gtk_progress_set_percentage(GTK_PROGRESS(bar_), Percent/100.0);
   
   // flush
   while (gtk_events_pending())
     gtk_main_iteration();
}
   
void 
OpDialogProgress::Done()
{
  gtk_progress_set_percentage(GTK_PROGRESS(bar_), 0.0);
}
   
OpDialogProgress::OpDialogProgress(const char* title)
  : dialog_(0), bar_(0), label_(0)
{
  dialog_ = gnome_dialog_new(title,
                             GNOME_STOCK_BUTTON_CANCEL, 
                             NULL);

  gnome_apt_setup_dialog(dialog_);

  gtk_window_set_default_size(GTK_WINDOW(dialog_), 300, -1);

  bar_ = gtk_progress_bar_new();

  label_ = gtk_label_new("");

  gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog_)->vbox),
                     label_, 
                     TRUE, TRUE, GNOME_PAD);
  
  gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog_)->vbox),
                     bar_, 
                     TRUE, TRUE, GNOME_PAD);

  gtk_widget_show_all(dialog_);
}

OpDialogProgress::~OpDialogProgress()
{
  gtk_widget_destroy(dialog_);
  dialog_ = bar_ = label_ = 0;
}
