/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *   Gnome Apt frontend
 *
 *   Copyright (C) 1998 Havoc Pennington <hp@pobox.com>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GNOME_APT_SEARCH_H
#define GNOME_APT_SEARCH_H

#include "gnome-apt.h"
#include "cache.h"
#include "pkgutil.h"
#include "pkgtree.h"

#include <vector>
#include <map>
#include <stack.h>

class SearchPattern {
public:
  SearchPattern() : case_sensitive_(false) {}
  ~SearchPattern() {}

  typedef enum {
    Package,
    Maintainer,
    Conffiles,
    ShortDescription,
    LongDescription,
    // more later...
    TextFieldTypeEnd
  } TextFieldType;

  void set_textfield(TextFieldType tft, bool state) {
    textfields_[tft] = state;
  }

  bool get_textfield(TextFieldType tft) {
    map<TextFieldType,bool>::iterator i = textfields_.find(tft);
    if (i != textfields_.end()) 
      return i->second;
    else 
      return true;  // default to true
  }

  void set_case_sensitive(bool state) { case_sensitive_ = state; }
  bool get_case_sensitive() { return case_sensitive_; }

  void add_regexp(string & re) { regexps_.push_back(re); }

  class Hit {
  public:
    pkgCache::Package* package;
    guint weight;

    Hit(pkgCache::Package* p, guint w) : package(p), weight(w) {}

  };

  class HitCompare {
  public:
    bool operator() (const Hit & a, const Hit & b) {
      return a.weight < b.weight;
    }
  };

  static HitCompare hit_compare;

  void search(GAptCacheFile* cachefile,
              priority_queue<Hit,vector<Hit>,HitCompare> & hits);

private:
  bool case_sensitive_;
  vector<string> regexps_;
  map<TextFieldType,bool> textfields_;

  // more stuff to come
};


void      gnome_apt_search(GAptPkgTree* tree);

#endif
