/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *   Gnome Apt frontend
 *
 *   Copyright (C) 1998 Havoc Pennington <hp@pobox.com>
 *
 *       Changes by Olivier Aubin <ogaubin@ucalgary.ca>, 1999
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GNOME_APT_SOURCES_H
#define GNOME_APT_SOURCES_H

#include "gnome-apt.h"

#include "pkglist.h"

#include "gnome-drud.h"

class pkgSourceList;

class Sources {
public:
  Sources();
  ~Sources();

  void edit();

  void set_pkglist(GAptPkgList* pl) { pkglist_ = pl; }

  void setup_dialog(GtkWindow* w);

  typedef enum {
    Ok,
    BadDist,
    BadURI,
    BadSection
  } SourceAddResult;
  
  SourceAddResult add_source(gchar* dist, gchar* uri, gchar* section);
  
private:
  pkgSourceList* list_;

  GtkWidget* dialog_;

  GAptPkgList* pkglist_;

  GtkWidget* clist_;

  GtkWidget* b_add_;
  GtkWidget* b_del_;
  GtkWidget* b_edit_;

  GtkWidget* edit_dialog_;
  GtkWidget* edit_dialog_dist_;
  GtkWidget* edit_dialog_uri_;
  GtkWidget* edit_dialog_section_;

  /*
   * We only allow one row to be select at a time. This can be considered a
   * bug and should be fixed to allow multiple row selection...
   */
  gint selected_row_;

  static void apply_cb (GtkWidget* w, gint page, gpointer data);
  void apply(gint page);

  static void help_cb  (GtkWidget* w, gint page, gpointer data);
  void help (gint page);

  static gint close_cb (GtkWidget* w, gpointer data);
  gint close();

  static void changed_cb (GtkWidget* w, gpointer data);
  void changed();  

  static void add_wizard_cb (GtkWidget* w, gpointer data);
  void add_wizard();

  static void delete_source_cb (GtkWidget* w, gpointer data);
  void delete_source();

  static void edit_source_cb (GtkWidget* w, gpointer data);
  void edit_source();

  static gint edit_source_close_cb(GnomeDialog* d, gpointer data);
  void edit_source_close();

  static void edit_source_click_cb(GnomeDialog* d, gint arg, gpointer data);
  void edit_source_ok();

  static void select_row_cb(GtkCList* clist, gint row, gint column,
                            GdkEventButton* e, gpointer data);
  void select_row(gint row, gint column);

  static void unselect_row_cb(GtkCList* clist, gint row, gint column,
                              GdkEventButton* e, gpointer data);
  void unselect_row(gint row, gint column);
};

Sources* gnome_apt_sources();
void     gnome_apt_sources_shutdown();

#endif
