#!/bin/sh
if [ $# != 2 ]; then
	echo
	echo This utility is intended to be called from the Makefile
	echo install_helps.sh module /usr/lib/linuxconf
	echo
	echo Install the help files of one language of a module
	echo
else
	PWD=`pwd`
	LANG=`basename $PWD`
	if [ "$LANG" = "sources" ] ; then
		LANG=eng
	fi
	HELPDIR=$2/help.$LANG/$1
	rm -fr $HELPDIR
	mkdir -p $HELPDIR
	NBHELP=`find . -name \*.help | wc -l`
	NBHTML=`find . -name \*.html | wc -l`
	if [ $NBHELP != 0 -a $NBHTML != 0 ] ; then
		echo "    " Installing "*.html and *.help" in $HELPDIR
		install -m 644 -o root -g root *.help *.html $HELPDIR
	elif [ $NBHELP != 0 ] ; then
		echo "    " Installing "*.help" in $HELPDIR
		install -m 644 -o root -g root *.help $HELPDIR
	elif [ $NBHTML != 0 ] ; then
		echo "    " Installing "*.html" in $HELPDIR
		install -m 644 -o root -g root *.html $HELPDIR
	else
		echo "    " Nothing to install
	fi
fi
