/* #Specification: FIELD_PASSTHROUGH / principle
	Linuxconf supports multiple user interface. From a generic DIALOG
	interface, it builds HTML, Text and GUI dialogs. These dialogs are
	uniform, but sometime, one wishes to make the GUI version more
	appealing. The FIELD_PASSTHROUGH is used to record GUI commands.
	See <htmlurl
		url=http://www.solucorp.qc.ca/linuxcong/tech/guiapi
		>

	When a single FIELD_PASSTHROUGH is defined in a dialog, linuxconf
	assume the dialog is layed out manually, so the programmer is
	free to implement about any disposition he wants.

	FIELD_PASSTHROUGH has no effect for the HTML and Text interface.
*/
#include "dialog.h"
#include "../diajava/proto.h"

// Function needed to force the linkage of pass.o
void pass_required(){}

class FIELD_PASSTHROUGH: public FIELD{
	int command;
	SSTRING args;
	/*~PROTOBEG~ FIELD_PASSTHROUGH */
public:
	FIELD_PASSTHROUGH (int _command,
		 const char *_args);
	void dokey (WINDOW *, int , FIELD_MSG&);
	void drawtxt (WINDOW *);
	char getidprefix (void);
	void gui_draw (int , int &);
	void gui_get (int);
	void html_draw (int);
	int html_validate (int);
	bool is_passthrough (void);
	void reload (const char *, int);
	void restore (void);
	void save (void);
	/*~PROTOEND~ FIELD_PASSTHROUGH */
};


PUBLIC FIELD_PASSTHROUGH::FIELD_PASSTHROUGH(int _command, const char *_args)
	: FIELD ("")
{
	command = _command;
	args.setfrom (_args);
	vsize = 0;
	readonly = 1;
}

PUBLIC void FIELD_PASSTHROUGH::drawtxt(WINDOW *){}
PUBLIC void FIELD_PASSTHROUGH::dokey(WINDOW *, int , FIELD_MSG &){}
PUBLIC void FIELD_PASSTHROUGH::save(){}
PUBLIC void FIELD_PASSTHROUGH::restore(){}
PUBLIC void FIELD_PASSTHROUGH::reload(const char *, int ){}
PUBLIC void FIELD_PASSTHROUGH::html_draw(int){}
PUBLIC void FIELD_PASSTHROUGH::gui_get(int ){}
PUBLIC char FIELD_PASSTHROUGH::getidprefix (){return ' '; }
PUBLIC int  FIELD_PASSTHROUGH::html_validate(int ){ return 0;}


PUBLIC void FIELD_PASSTHROUGH::gui_draw(int, int &)
{
	diagui_sendcmd (command,"%s\n",args.get());
}

PUBLIC bool FIELD_PASSTHROUGH::is_passthrough()
{
	return true;
}


/*
	Record a GUI command. This only affect the GUI.
	Using this override the normal disposition done for the GUI. You
	are on your own...
*/
PUBLIC void DIALOG::gui_passthrough(int command, const char *args, ...)
{
	va_list list;
	va_start (list,args);
	char buf[1000];
	vsnprintf (buf,sizeof(buf)-1,args,list);
	add (new FIELD_PASSTHROUGH(command,buf));
	va_end (list);
}


/*
	Record a GUI command. This only affect the GUI.
	Using this override the normal disposition done for the GUI. You
	are on your own...
*/
PUBLIC void DIALOG::gui_passthroughv(int command, const char *args, va_list list)
{
	char buf[1000];
	vsnprintf (buf,sizeof(buf)-1,args,list);
	add (new FIELD_PASSTHROUGH(command,buf));
}

/*
	Record a line change command. This only affect the GUI.
	Using this override the normal disposition done for the GUI. You
	are on your own...
*/
PUBLIC void DIALOG::newline()
{
	gui_passthrough (P_Newline,"");
}

