#include "dialog.h"
#include "../diajava/proto.h"


class FIELD_TEXTAREA: public FIELD{
	int width;
	SSTRING &text;
	SSTRING buf;
	SSTRING backup;
	/*~PROTOBEG~ FIELD_TEXTAREA */
public:
	FIELD_TEXTAREA (const char *prompt,
		 SSTRING&_text,
		 int _width,
		 int height);
	void dokey (WINDOW *, int , FIELD_MSG&);
	void drawtxt (WINDOW *);
	char getidprefix (void);
	void gui_draw (int nofield, int &);
	void gui_get (int nofield);
	void html_draw (int nofield);
	int html_validate (int);
	void reload (const char *dianame, int nof);
	void restore (void);
	void save (void);
protected:
	void sendlines (void);
public:
	/*~PROTOEND~ FIELD_TEXTAREA */
};

PUBLIC FIELD_TEXTAREA::FIELD_TEXTAREA(
	const char *prompt,
	SSTRING &_text,
	int _width,		// How many visible character horizontally
					// (a hint)
	int height)		// How many lines to show
	: FIELD (prompt), text(_text)
{
	width = _width;
	vsize = height;
	backup.setfrom (text);
	buf.setfrom (text);
}


PUBLIC void FIELD_TEXTAREA::drawtxt(WINDOW *)
{
}

PUBLIC void FIELD_TEXTAREA::dokey(WINDOW *, int , FIELD_MSG &)
{
}

PUBLIC void FIELD_TEXTAREA::save()
{
	text.setfrom(buf);
}

PUBLIC void FIELD_TEXTAREA::restore()
{
	text.setfrom(backup);
}

PUBLIC void FIELD_TEXTAREA::reload(const char *dianame, int nof)
{
	buf.setfrom (text);
	if (dianame != NULL){
		diagui_sendcmd (P_Setval,"%s T%d reset\n",dianame,nof);
		sendlines();
	}
}
/*
	Send the text to the GUI front-end line by line
*/
PROTECTED void FIELD_TEXTAREA::sendlines()
{
	const char *pt = buf.get();
	while (*pt != '\0'){
		char line[1000];
		char *dst = line;
		while (*pt != '\n' && *pt != '\0'
			&& (unsigned)(dst-line)<sizeof(line)) *dst++ = *pt++;
		*dst = '\0';
		char tmp[1000];
		diagui_sendcmd (P_Str,"%s\n",diagui_quote(line,tmp));
		if (*pt == '\n') pt++;
	}
	diagui_sendcmd (P_End,"\n");
}

PUBLIC void FIELD_TEXTAREA::html_draw(int nofield)
{
	html_printf ("<tr><td>%s<td>",prompt);
	if (readonly){
		html_printf ("%s\n",buf.get());
	}else{
		char key[100];
		format_htmlkey (key,nofield);
		html_printf ("<textarea name=%s rows=%d cols=%d>\n",key,vsize
			,width);
		html_printf ("%s\n",buf.get());
		html_printf ("</textarea>\n");
	}
}

PUBLIC void FIELD_TEXTAREA::gui_draw(int nofield, int &)
{
	if (prompt[0] != '\0'){
		diagui_send_Label (prompt);
	}else{
		diagui_sendcmd (P_Skip,"1\n");
	}
	if (readonly){
		diagui_send_Label (buf.get());
	}else{
		diagui_sendcmd (P_Textarea,"T%d %d %d\n",nofield,width,vsize);
		sendlines();
	}
}

PUBLIC void FIELD_TEXTAREA::gui_get(int nofield)
{
	SSTRINGS tb;
	int nb = diagui_getvals('T',nofield,tb);
	int len = 0;
	for (int i=0; i<nb; i++){
		len += tb.getitem(i)->getlen()+1;
	}
	char tmp[len+1];
	char *acc = tmp;
	for (int i=0; i<nb; i++){
		tb.getitem(i)->copy (acc);
		acc += strlen(acc);
		*acc ++ = '\n';
	}
	*acc = '\0';
	buf.setfrom (tmp);
}

PUBLIC char FIELD_TEXTAREA::getidprefix ()
{
	return 'T';
}

PUBLIC int FIELD_TEXTAREA::html_validate(int)
{
	return 0;
}

PUBLIC void DIALOG::newf_textarea (
	const char *prompt,
	SSTRING &text,
	int width,		// How many visible character horizontally
					// (a hint)
	int height)		// How many lines to show
{
	add (new FIELD_TEXTAREA(prompt,text,width,height));
}

