#pragma interface
#ifndef INTERNAL_H
#define INTERNAL_H

#ifndef MISC_H
	#include <misc.h>
#endif
#ifndef MODULE_H
	#include <module.h>
#endif

#ifndef NETCONF_H
	#include <netconf.h>
#endif
#ifndef DAEMONI_H
	#include <daemoni.h>
#endif

#include <modapi_def.h>
#include <modapi.h>

/* known/unknown directives handling */

#define NORMAL 0
#define UNKNOWN 1

#define OUT 1
#define IN 2

#define d_DIR 1
#define d_DIRMATCH 2
#define d_FILE 3
#define d_FILEMATCH 4

class APACHE_HELP_FILE: public HELP_FILE{
	/*~PROTOBEG~ APACHE_HELP_FILE */
public:
	APACHE_HELP_FILE (const char *fname);
	/*~PROTOEND~ APACHE_HELP_FILE */
};

class MODULE_APACHE: public LINUXCONF_MODULE{
	/*~PROTOBEG~ MODULE_APACHE */
public:
	MODULE_APACHE (void);
	int domenu (MENU_CONTEXT context,
		 const char *key);
	int execmain (int argc, char *argv[]);
	void setmenu (DIALOG&dia, MENU_CONTEXT context);
	void usage (SSTRINGS&tb);
	/*~PROTOEND~ MODULE_APACHE */
};
class HTTPD_UNKNOWNS;
class HTTPD_CONFIG;
class HTTPD_DIR;
class HTTPD_DOMAIN;

class HTTPD_DOMAINS: public ARRAY{
	/*~PROTOBEG~ HTTPD_DOMAINS */
public:
	int edit (HTTPD_CONFIG&_httpd);
	HTTPD_DOMAIN *getitem (int no);
	int write (void);
	/*~PROTOEND~ HTTPD_DOMAINS */
};

class HTTPD_DIRS: public ARRAY{
	/*~PROTOBEG~ HTTPD_DIRS */
public:
	int edit (HTTPD_CONFIG&_httpd);
	int f_edit (HTTPD_CONFIG&_httpd);
	HTTPD_DIR *getitem (int no)const;
	void write (FILE *fout);
	int write (void);
	/*~PROTOEND~ HTTPD_DIRS */
};
class HTTPD_USERS;

class HTTPD_USER: public ARRAY_OBJ { 
public:
	SSTRING comment;
	SSTRING user;
	SSTRING pass;

 	/*~PROTOBEG~ HTTPD_USER */
public:
	int edit (HTTPD_USERS&users);
	/*~PROTOEND~ HTTPD_USER */
};

class HTTPD_USERS: public ARRAY{
public:
	CSSTRING file;
	HTTPD_USER *getitem (int no);
	int cwrite(void);	
	int edit(void);
	HTTPD_USERS ();
};

class HTTPD_AUTHS: public ARRAY { 
public:
	HTTPD_USERS *getitem (int no);
	int edit();
};

class HTTPD_UNKNOWN: public ARRAY_OBJ{
public:
	CSSTRING name;
	SSTRING param;
	SSTRINGS tbunknown;
	HTTPD_DIRS dirs;
	HTTPD_DOMAINS doms;

	/*~PROTOBEG~ HTTPD_UNKNOWN */
public:
	HTTPD_UNKNOWN (const char *cname,
		 const char *cparam);
	HTTPD_UNKNOWN (void);
	void write (FILE *fout);
	/*~PROTOEND~ HTTPD_UNKNOWN */
};
class HTTPD_UNKNOWNS: public ARRAY {
public:
	SSTRING lastname;
	SSTRING lastparam;
	HTTPD_UNKNOWN unk;
	/*~PROTOBEG~ HTTPD_UNKNOWNS */
public:
	HTTPD_UNKNOWNS (void);
	HTTPD_UNKNOWN *getitem (int no);
	/*~PROTOEND~ HTTPD_UNKNOWNS */
};



class HTTPD_FEATURES{
public:
	char indexes;
	char followsymlinks;
	char includes;
	char execcgi;
	char symlinksifownermatch;
	char multiviews;
	char includesnoexec;
	SSTRING comment;

	/*~PROTOBEG~ HTTPD_FEATURES */
public:
	HTTPD_FEATURES (void);
	void setallopt (int val);
	void setdia (DIALOG&dia);
	void write (const char *prefix, FILE *fout);
	/*~PROTOEND~ HTTPD_FEATURES */
};
class HTTPD_OVERRIDE{
public:
	char authconfig;
	char fileinfo;
	char indexes;
	char limit;
	char options;
	SSTRING comment;

	/*~PROTOBEG~ HTTPD_OVERRIDE */
public:
	HTTPD_OVERRIDE (void);
	void setallopt (int val);
	void setdia (DIALOG&dia);
	void write (const char *prefix, FILE *fout);
	/*~PROTOEND~ HTTPD_OVERRIDE */
};

/* mod_ssl configuration within <IfModule mod_ssl.c> */
/* Fri Apr 23 1999 : Marcelo */

class HTTPD_CONFIG;
struct shared_ssl {
	int SSLSessionCacheTimeout;
	SSTRING SSLSessionCacheTimeoutC;

	int SSLVerifyDepth;
	SSTRING SSLVerifyDepthC;

	char SSLEngine;
	SSTRING SSLEngineC;

	CSSTRING SSLProtocol;
	CSSTRING SSLCipherSuite;
	CSSTRING SSLCertificateFile;
	CSSTRING SSLCertificateKeyFile;
	CSSTRING SSLCACertificatePath;
	CSSTRING SSLCACertificateFile;
	CSSTRING SSLVerifyClient;
	CSSTRING SSLLog;
	CSSTRING SSLLogLevel;
	CSSTRING SSLOptions;
};

class HTTPD_SSL {
public:
	CSSTRING SSLPassPhraseDialog;
	CSSTRING SSLSessionCache;
	CSSTRING SSLMutex;
	SSTRINGS SSLRandomSeed;

	struct shared_ssl opts;

	bool cwrite;

	/*~PROTOBEG~ HTTPD_SSL */
public:
	HTTPD_SSL (void);
	int edit (HTTPD_CONFIG&_httpd);
	void write (FILE *fout);
	/*~PROTOEND~ HTTPD_SSL */
};



class HTTPD_DIR: public ARRAY_OBJ{
public:
	SSTRING path;
	HTTPD_FEATURES feats;
	HTTPD_OVERRIDE over;
	HTTPD_UNKNOWNS unks;

	CSSTRING AuthUserFile;
	CSSTRING AuthGroupFile;

	CSSTRING SSLCipherSuite;
	CSSTRING SSLVerifyClient;
	CSSTRING SSLOptions;
	CSSTRING SSLRequire;

	char SSLRequireSSL;
	SSTRING SSLRequireSSLC;

	int SSLVerifyDepth;
	SSTRING SSLVerifyDepthC;

	SSTRINGS tbunknown;

	HTTPD_AUTHS auths;

	int dmode;

	/*~PROTOBEG~ HTTPD_DIR */
public:
	HTTPD_DIR (const char *path);
	HTTPD_DIR (void);
	int edit (void);
	int f_edit (void);
private:
	void init (void);
public:
	void write (FILE *fout);
	/*~PROTOEND~ HTTPD_DIR */
};

class HTTPD_DOMSSL{
public:
	struct shared_ssl opts;
public:
	void setdia (DIALOG&dia);
	void write (const char *prefix, FILE *fout);
	HTTPD_DOMSSL();
};

class HTTPD_DOMOPT{
public:
	//CSSTRING host;
	CSSTRING serveradmin;
	CSSTRING servername;
	CSSTRING namevhost;
	CSSTRING documentroot;
	CSSTRING errorlog;
	CSSTRING transferlog;
	CSSTRING agentlog;
	CSSTRING refererlog;
	CSSTRING scriptalias;
	CSSTRING setuiduser;
	CSSTRING setuidgroup;
	HTTPD_FEATURES feats;
	HTTPD_UNKNOWNS unks;
	SSTRINGS tbunknown;		// Directives not managed by this module
	/*~PROTOBEG~ HTTPD_DOMOPT */
public:
	void setdia (DIALOG&dia, bool advanced);
	void write (const char *prefix, FILE *fout);
	/*~PROTOEND~ HTTPD_DOMOPT */
};

class HTTPD_DOMAIN: public ARRAY_OBJ{
public:
	SSTRING name;
	CSSTRING serveralias;
	HTTPD_DOMOPT opt;
	HTTPD_DOMSSL ssl;
	HTTPD_DIRS dirs;
	HTTPD_UNKNOWNS unks;

	/*~PROTOBEG~ HTTPD_DOMAIN */
public:
	HTTPD_DOMAIN (const char *domain);
	HTTPD_DOMAIN (void);
	int createroot (void);
	int edit (void);
	void write (FILE *fout);
	/*~PROTOEND~ HTTPD_DOMAIN */
};


class HTTPD_CONFIG{
public:
	int mode;
	int in_use;			// Httpd is operationnal on this system
	SSTRING comment_port;
	int port;
	SSTRING comment_startservers;
	int startservers;
	SSTRING comment_maxclients;
	int maxclients;
	SSTRING comment_maxrequestsperchild;
	int maxrequestsperchild;
	SSTRING comment_minspareservers;
	int minspareservers;
	SSTRING comment_maxspareservers;
	int maxspareservers;
	SSTRING comment_servertype;
	char servertype;	// 0: Standalone
						// 1: inetd
	SSTRING comment_keepalive;
	char keepalive;

	SSTRING comment_keepalivereq;
	int	maxkeepalivereq;

	SSTRING comment_keepalive_timeout;
	int keepalive_timeout;

	SSTRING comment_hostnamelookups;
	char hostnamelookups;


	CSSTRING serverroot;
	CSSTRING pidfile;
	#if 0
		CSSTRING user;
		CSSTRING group;
	#endif
	HTTPD_DOMAINS domains;
	HTTPD_DOMOPT defdom;		// Option of the main domain
	HTTPD_DIRS dirs;
	HTTPD_UNKNOWNS unks;
	HTTPD_SSL defssl;

	SSTRINGS lmodules;
	SSTRINGS amodules;

	char ClearModuleList;
	SSTRING ClearModuleListC;

	SSTRING comment_timeout;
	int timeout;
	CSSTRING scoreboardfile;
	/*~PROTOBEG~ HTTPD_CONFIG */
public:
	HTTPD_CONFIG (void);
	int editdefaults (void);
	HTTPD_DOMAIN *locatevhost (const char *vhost);
	int modedit (HTTPD_CONFIG&_httpd);
	int perfedit (HTTPD_CONFIG&_httpd);
	int write (void);
	/*~PROTOEND~ HTTPD_CONFIG */
};

class DAEMON_HTTPD: public DAEMON_INTERNAL{
	/*~PROTOBEG~ DAEMON_HTTPD */
	/*~PROTOEND~ DAEMON_HTTPD */
};

#include "apache.p"

#endif

