/* ***********
	To create this module, I ran the setupmod.sh script while in the
	modules/ sub-directory. I answered the few question and end up with
	this source file, a Makefile and a _dict.c.

	After I have stuffed the code needed for the module, I ran

	make msg

		to create the message dictionnary

	by hand	

		update motd.h and stuffed the various prototype

	make

		to compile it

	make install

		as root, to install the module.
		Then I ran linuxconf, visit the "control files and systems"
		menu and then the "linuxconf modules" menu and add the "motd"
		module there. Imediatly, I was able to

			-change the /etc/motd from the user account menu at the end
			-assign co-administrator for that task

   ***********
*/
#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "motd.h"
#include "motd.m"
#include <translat.h>
#include <subsys.h>
#include <userconf.h>

static HELP_FILE help_motd ("motd","motd");
static const char subsys_motd[]="motd";
static LINUXCONF_SUBSYS subb (subsys_motd,P_MSG_U(M_motd,"Message of the day"));
static PRIVILEGE p_motd ("motd",P_MSG_R(M_motd)
	,P_MSG_U(T_PMISC,"9-Miscellaneous"));


static CONFIG_FILE f_motd ("/etc/motd",help_motd
		,CONFIGF_OPTIONNAL|CONFIGF_MANAGED
		,subsys_motd);


MODULE_DEFINE_VERSION(motd);

PUBLIC MODULE_motd::MODULE_motd()
	: LINUXCONF_MODULE("motd")
{
	linuxconf_loadmsg ("motd",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_motd::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_USER_POLICIES){
		keymenu = MSG_R(M_motd);
		dia.new_menuitem ("",keymenu);
	}
}

static void motd_edit()
{
	SSTRINGS tb;
	FILE *fin = f_motd.fopen("r");
	if (fin != NULL){
		char buf[200];
		while (fgets_strip(buf,sizeof(buf)-1,fin,NULL)!=NULL){
			tb.add (new SSTRING (buf));
		}
	}
	// Add 5 empty lines at the end
	for (int i=0; i<5; i++) tb.add (new SSTRING);
	// Create the dialog to change the message.
	// Note: Linuxconf lack a real text editor widget so we are using
	//       a bunch of independant one line field.
	DIALOG dia;
	// SSTRINGS is a table of SSTRING. SSTRING are simple string object
	// using malloc() to store the text, so support any size string.
	// SSTRING is derived from ARRAY_OBJ and SSTRINGS is derived from
	// ARRAY. So we can have as many SSTRING in a SSTRINGS as needed.
	// the getnb() and getitem() function of the ARRAY object are used
	// everywhere in linuxconf.
	const char *title = MSG_U(F_MOTD,"Text of the message");
	for (int i=0; i<tb.getnb(); i++){
		dia.newf_str (title,*tb.getitem(i));
		title = "";
	}
	int nof = 0;	// Remember the current edit field during the loop
					// We can set the current field using that when
					// showing an error also.
	while (1){
		MENU_STATUS code = dia.edit (MSG_R(M_motd)
			,MSG_U(I_MOTD
				,"The following message is shown each time\n"
				 "a user is login in")
			,help_motd
			,nof);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else{
			// We clean up the empty line at the end
			// After an Accept, the SSTRINGs are updated from the dialog
			// state (DIALOG::save is called implicitly).
			for (int i=tb.getnb()-1; i>=0; i--){
				SSTRING *s = tb.getitem(i);
				if (s->is_empty()){
					tb.remove_del (s);
				}else{
					break;
				}
			}
			// Now we save the file. We use the privilege object to
			// allow the co-administrator to perform his duties
			// The privilege is used only here since /etc/motd is not
			// security related (anyone may see it, not anyone may modify
			// it).
			FILE *fout = f_motd.fopen (&p_motd,"w");
			if (fout != NULL){
				for (int i=0; i<tb.getnb(); i++){
					fprintf (fout,"%s\n",tb.getitem(i)->get());
				}
				fclose (fout);
				break;
			}
		}
	}
}


PUBLIC int MODULE_motd::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_USER_POLICIES){
		if (key == keymenu){
			motd_edit();
		}
	}
	return 0;
}


PUBLIC int MODULE_motd::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"motd")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"Module motd\n"
		 "\n"
		 "    No command line option\n")
		);
}

PUBLIC int MODULE_motd::execmain (int argc , char *argv[])
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"motd")==0){
		ret = -1;
		if (argc == 1){
			// ### Place call to main menu of the module
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


static MODULE_motd motd;

