#pragma interface
#ifndef NETADM_H
#define NETADM_H

#ifndef MISC_H
	#include <misc.h>
#endif
#ifndef MODULE_H
	#include <module.h>
#endif

#define PROTO_VERSION	"1"
#include <modapi_def.h>
#include <modapi.h>

class MODULE_NETADM: public LINUXCONF_MODULE{
	/*~PROTOBEG~ MODULE_NETADM */
public:
	MODULE_NETADM (void);
	int dohtml (const char *key);
	int domenu (MENU_CONTEXT context,
		 const char *key);
	int execmain (int argc, char *argv[]);
	void setmenu (DIALOG&dia, MENU_CONTEXT context);
	void usage (SSTRINGS&tb);
	/*~PROTOEND~ MODULE_NETADM */
};

class CLUSTER: public ARRAY_OBJ{
public:
	SSTRING id;			// Name of this configuration
	SSTRING comment;	// Description
	SSTRING tree;		// Administration tree used to pick the config
						// file for sharing.
	SSTRINGS members;	// Machines which are co-managed
	SSTRINGS subsyss;	// Which sub-system are shared on those machines
	/*~PROTOBEG~ CLUSTER */
public:
	CLUSTER (const char *_id);
	CLUSTER (void);
private:
	void delinfo (void);
public:
	int edit (void);
	int exportall (void);
private:
	int exportone (const char *member, const char *pass);
public:
	int publish (void);
private:
	void update_subsyss (SSTRINGS&tbsys,
		 char tbsys_sel[]);
public:
	void write (void);
	/*~PROTOEND~ CLUSTER */
};

class CLUSTERS: public ARRAY{
	/*~PROTOBEG~ CLUSTERS */
public:
	CLUSTERS (void);
	int edit (void);
	CLUSTER *getitem (int no)const;
	int publish (const char *tree);
	int write (void);
	/*~PROTOEND~ CLUSTERS */
};

#define PROTO_C_PROMPT	100
#define PROTO_C_DATA	110
#define PROTO_C_COMMENT	220
#define PROTO_C_ACK		250
#define PROTO_C_ERROR	500


// Use to do buffering of input and check for timeout
class SLAVE_FCTL{
	int fdin;
	char accum[40000];
	int nbacc;
	/*~PROTOBEG~ SLAVE_FCTL */
public:
	SLAVE_FCTL (int _fdin);
	int gets (char *buf, int size);
	int readlen (void *buf, int size);
	int readlen (void *buf, int size, bool linemode);
	int readok (void *buf, int size);
	/*~PROTOEND~ SLAVE_FCTL */
};


#include "netadm.p"

#endif

