#!/bin/sh

. /usr/lib/linuxconf/install/rpm-identdist.sh

echo "#### /usr/lib/linuxconf/install/rpm-postinst.sh" >>/tmp/linuxconf-rpminstall.log
date >>/tmp/linuxconf-rpminstall.log

log(){
	echo $* >>/tmp/linuxconf-rpminstall.log
	$*
}

# Things to do after installing

# This script is handed a 1 if it is a new install
# and a 2 if it is an upgrade

# Touch the various log files, so we get no logrotate errors...
if [ ! -f /var/log/htmlaccess.log ] ; then
	log touch /var/log/htmlaccess.log
fi

if [ ! -f /var/log/boot.log ] ; then
	log touch /var/log/boot.log
fi

if [ ! -f /var/log/netconf.log ] ; then
	log touch /var/log/netconf.log
fi

if [ -f $PATHRCINIT.beforelinuxconf ] ; then
	log mv -f $PATHRCINIT.beforelinuxconf /usr/lib/linuxconf/uninstall/
fi

if [ -f $PATHRC.beforelinuxconf ] ; then
	log mv -f $PATHRC.beforelinuxconf /usr/lib/linuxconf/uninstall/
fi

if [ -f /etc/inetd.conf.beforelinuxconf ] ; then
	log mv -f /etc/inetd.conf.beforelinuxconf /usr/lib/linuxconf/uninstall/
fi

if [ -f /etc/services.beforelinuxconf ] ; then
	log mv -f /etc/services.beforelinuxconf /usr/lib/linuxconf/uninstall/
fi

# Is this the first install?
if [ ! -f /usr/lib/linuxconf/uninstall/options ] ; then
	touch /usr/lib/linuxconf/uninstall/options
	chmod 550 /usr/lib/linuxconf/uninstall/options
	echo FIRST INSTALL >> /usr/lib/linuxconf/uninstall/options
else
	echo Upgraded to Linuxconf `date` >> /usr/lib/linuxconf/uninstall/options
fi

# Replace /etc/inittab if the upgrade needs it.
if [ -f $INITTABREPLACE ] ; then
	log rm -f $INITTABREPLACE
	log cp -f /usr/lib/linuxconf/install/$INITTAB /etc/inittab
fi

# Update /etc/rc.d/rc.sysinit
if [ "$PATHRCINIT" != "" ] ; then
	if [ `grep askrunlevel $PATHRCINIT | wc -l` = 0 ] ; then
		if [ ! -f /usr/lib/linuxconf/uninstall/$RCINIT.beforelinuxconf ] ; then
			log cp $PATHRCINIT /usr/lib/linuxconf/uninstall/$RCINIT.beforelinuxconf
		fi
		if [ "$USE_SED_ON_RCS" = "Y" ] ; then
			mv $PATHRCINIT $PATHRCINIT.old
			sed "s.exit 0./sbin/askrunlevel." <$PATHRCINIT.old \
				>$PATHRCINIT
		else
			echo >> $PATHRCINIT
			echo /sbin/askrunlevel >> $PATHRCINIT
		fi
		chown root.root $PATHRCINIT
		chmod 755 $PATHRCINIT
	else
		if [ ! `grep FIRST /usr/lib/linuxconf/uninstall/options | wc -l` = 0 ] ; then
			echo $PATHRCINIT >> /usr/lib/linuxconf/uninstall/options
		fi
	fi
fi

# Replace /etc/rc.d/rc
if [ "$PATHRC" != "" ] ; then
	if [ `grep netconf $PATHRC | wc -l` = 0 ] ; then
		if [ ! -f /usr/lib/linuxconf/uninstall/rc.beforelinuxconf ] ; then
			log mv $PATHRC /usr/lib/linuxconf/uninstall/rc.beforelinuxconf
		fi

		log cp -af /usr/lib/linuxconf/install/$RCSYSV  $PATHRC
		echo "# Please Do Not Removed This Line! ?10866? " >> $PATHRC
		chown root.root $PATHRC
		chmod 755 $PATHRC
	else
		if [ ! `grep FIRST /usr/lib/linuxconf/uninstall/options | wc -l` = 0 ] ; then
			echo $PATHRC >> /usr/lib/linuxconf/uninstall/options
		fi
	fi
fi

# Update /etc/inetd.conf
if [ `grep linuxconf /etc/inetd.conf | wc -l` = 0 ] ; then
	if [ ! -f /usr/lib/linuxconf/uninstall/inetd.conf.beforelinuxconf ] ; then
		log cp /etc/inetd.conf /usr/lib/linuxconf/uninstall/inetd.conf.beforelinuxconf
	fi

	echo >> /etc/inetd.conf
	echo linuxconf stream tcp wait root /bin/linuxconf linuxconf --http >> /etc/inetd.conf
	if [ -f /var/run/inetd.pid ] ; then
		kill -HUP `cat /var/run/inetd.pid`
	fi
else	
	if [ ! `grep FIRST /usr/lib/linuxconf/uninstall/options | wc -l` = 0 ] ; then
		echo /etc/inetd.conf >> /usr/lib/linuxconf/uninstall/options
	fi
fi

# Update /etc/services
if [ `grep linuxconf /etc/services | wc -l` = 0 ] ; then
	if [ ! -f /usr/lib/linuxconf/uninstall/services.beforelinuxconf ] ; then
		log cp /etc/services /usr/lib/linuxconf/uninstall/services.beforelinuxconf
	fi
	
	echo "linuxconf	98/tcp		# added by linuxconf RPM" >> /etc/services
else	
	if [ ! `grep FIRST /usr/lib/linuxconf/uninstall/options | wc -l` = 0 ] ; then
		echo /etc/services >> /usr/lib/linuxconf/uninstall/options
	fi
fi

# Put in the /etc/conf.linuxconf if missing or empty
if [ ! -s /etc/conf.linuxconf ] ; then
	if [ -f /etc/conf.linuxconf-installed ] ; then
		log mv /etc/conf.linuxconf-installed /etc/conf.linuxconf
		log /usr/lib/linuxconf/lib/checkdist.sh $CHECKDIST
	elif [ -f /etc/conf.linuxconf.rpmsave ] ; then
		log mv /etc/conf.linuxconf.rpmsave /etc/conf.linuxconf
		log /usr/lib/linuxconf/lib/checkdist.sh $CHECKDIST
	else
		log cp /usr/lib/linuxconf/install/$SPCCONF /etc/conf.linuxconf
	
		$GRABINFO >>$GRABNOTICE
		if [ -s $GRABNOTICE ] ; then
			rm -f $GRABNOTICE
		fi
	fi
fi
# Enabling some modules
$SETMODULES >>/tmp/linuxconf-rpminstall.log

# Back Up /etc/hosts Just in case..
if [ -f /etc/hosts ] ; then
	if [ ! -f /usr/lib/linuxconf/uninstall/hosts.beforelinuxconf ] ; then
		log cp /etc/hosts /usr/lib/linuxconf/uninstall/hosts.beforelinuxconf
	fi
fi

# Remove The FIRST INSTALL line from uninstall options
if [ ! `grep FIRST /usr/lib/linuxconf/uninstall/options | wc -l` = 0 ] ; then
	grep -v FIRST /usr/lib/linuxconf/uninstall/options > /usr/lib/linuxconf/uninstall/options.tmp
	mv -f /usr/lib/linuxconf/uninstall/options.tmp /usr/lib/linuxconf/uninstall/options
fi

if [ "$SYSVLINUXCONF" != "" ] ; then
	if [ "$CHKCONFIG" != "" ] ; then
		# undo the symlinks in 1.12r5
		for dir in $RUNLEVELSPATH
		do
			log rm -f $dir/S00linuxconf $dir/S99linuxconf
		done
		log ln -sf $SYSVLINUXCONF/S99linuxconf $PATHINITD/linuxconf
		log $CHKCONFIG --add linuxconf
	else
		for dir in $RUNLEVELSPATH
		do
			log ln -sf $SYSVLINUXCONF/S99linuxconf $dir/S99linuxconf
		done
	fi
fi

