# copyright (C) 1997-1999 Jean-Luc Fontaine (mailto:jfontain@multimania.com)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: font.tcl,v 2.1 1999/08/28 18:40:58 jfontain Exp $}

# Note: on UNIX, for best results, make sure your X Window server has the proper dots-per-inch setting for your screen
# (eventually correct it using the -dpi option of your X server, as I do on my Linux machine)

class font {
    catch {widget::widget}       ;# force widget class load for static data members visibility below, in case of package utilization

    set ::font::(mediumBold) [eval font create [font actual $widget::(default,ButtonFont)]]
    font configure $(mediumBold) -weight bold                                                                ;# force weight to bold
    set ::font::(mediumNormal) [eval font create [font actual $(mediumBold)]]
    font configure $(mediumNormal) -weight normal                                                          ;# force weight to normal
    set ::font::(smallNormal) [eval font create [font actual $(mediumNormal)]]
    font configure $(smallNormal) -size [expr {round(0.8*[font actual $(mediumNormal) -size])}]  ;# small size is 80% of medium size
}

