------------------------------------------------------------------------------
--                                                                          --
--                 ASIS-for-GNAT IMPLEMENTATION COMPONENTS                  --
--                                                                          --
--                          A 4 G . M A P P I N G                           --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--            Copyright (c) 1995-1999, Free Software Foundation, Inc.       --
--                                                                          --
-- ASIS-for-GNAT is free software; you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. ASIS-for-GNAT is distributed  in the hope  that it will be use- --
-- ful, but WITHOUT ANY WARRANTY; without even the implied warranty of MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License  distributed with ASIS-for-GNAT; see file     --
-- COPYING. If not, write to the Free Software Foundation,  59 Temple Place --
-- - Suite 330,  Boston, MA 02111-1307, USA.                                --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- ASIS-for-GNAT was originally developed  by the ASIS-for-GNAT team at the --
-- Software  Engineering  Laboratory  of  the Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne,  Switzerland, in cooperation with the --
-- Scientific  Research  Computer  Center of  Moscow State University (SRCC --
-- MSU), Russia,  with funding partially provided  by grants from the Swiss --
-- National  Science  Foundation  and  the  Swiss  Academy  of  Engineering --
-- Sciences.  ASIS-for-GNAT is now maintained by  Ada Core Technologies Inc --
-- (http://www.gnat.com).                                                   --
--                                                                          --
------------------------------------------------------------------------------

with Asis;

with A4G.A_Types;  use A4G.A_Types;
with A4G.Int_Knds; use A4G.Int_Knds;

with Types;        use Types;
with Sinfo;        use Sinfo;

package A4G.Mapping is

--  ??? the documentation revision and restructurisation started, but
--  ??? not completed yet. See --  ### comment sentinel marking the point
--  ??? till which this restruturisation has been already done

   --  This package defines and implements the mapping from the AST
   --  nodes onto ASIS Elements.The main part of this mapping are:
   --
   --  - the function constructing an ASIS Element from a tree node;
   --  - the function constructing an ASIS Element_List from a tree
   --    node list;
   --  - a set of functions defining the ASIS kind (or, more exactly,
   --    the corresponding value of the Internal_Element_Kinds type)
   --    of an Element which can be built on the base of a given node.
   --    Most of these functions are hidden in the package body, but
   --    for some of them their specifications are placed in the
   --    package spec in order to make them visible for the
   --    implementation of some ASIS queries (for example, sometimes
   --    we have to know the exact kind of an operator symbol or
   --    of an attribute reference.

   --  Now for the functions of the two first kinds there exist two
   --  versions: one originated from the very first code developed
   --  in ASIS-for-GNAT implementation, another (having the names
   --  ending with _New) developed later. This situation is not
   --  normal, it would be nice to revise all the implementation
   --  code to make it to be based on the ..._New functions only,
   --  but for now it is not the first-priority goal. But all the
   --  newly-created code should use only these ..._New functions.

   --  As the result, the documentation and the overall structure of the
   --  code is also far from being perfect, and it should be also
   --  revised.


   --  The functions defined in this package are of relatively low level.
   --  In particular, as a rule, they do not check the correctness of
   --  their arguments, and a caller is responsible for the correct
   --  usage of these functions.


   -------------------------------------
   -- FROM AST NODES TO ASIS ELEMENTS --
   -------------------------------------

--  ???
   Parent_Node : Node_Id;
   --  The determination of the ASIS Internal Element Kind is based on
   --  the original tree nodes. Sometimes it requires information about
   --  the "context" of a node, that is, about its the parent node.
   --  If the node is rewritten, its original node has Parent field
   --  set to N_Empty. The global variable Parent_Node is used to
   --  transfer the parent node from Node_To_Element function to
   --  Asis_Internal_Element_Kind function.
   --
   --  For now, it is defined in the package spec, because it is needed
   --  by the current implementation of Enclosing_Element. As soon as
   --  the implementation of Enclosing _Element is rewritten on top of
   --  Traverse_Element, the declaration of Parent_Node should be
   --  moved in the body of the package



--   ???
--  ??? <tree problem 2>
   function Is_Not_Duplicated_Decl (Node : Node_Id) return Boolean;
   --  This function checks if Node does not correspond to the declaration
   --  which is included in the tree twice - first on its own and then
   --  as an original node for some rewritten structure. At least up to
   --  GNAT 3.07, this is the case for a type derived from private type
   --  and having no explicit constrain.
   --
   --  This function is plaved in the package spec, because it is used by
   --  A4G.Decl_Sem.Serach_First_View
--  ??? <tree problem 2> - end


   function Asis_Internal_Element_Kind
     (Node : Node_Id)
      return Internal_Element_Kinds;
   --  This function is the kernel of the tree node -> Asis Element
   --  mapping. Taking a tree Node, it defines the Internal_Element_Kinds
   --  value for the Element which may be constructed on the base of this
   --  node. should be an original, but not the rewritten node in case
   --  if tree rewriting takes place for a given construct.
   --
   --  This function does not check, whether or not an Element could be
   --  really construct for a given Node, a caller is responsible for
   --  obtaining the proper node for Element construction, or for filtering
   --  out inappropriate nodes in case when this function is applied
   --  to construct an Element_List.
   --
   --  This function is mage visible outside the package, because it it
   --  used by routines from A4G.C_U_Info/CU_Info package dealing with
   --  Compilation_Units.
   --
   --  If no Asis_Element could be constructed on the base of the Node,
   --  then ASIS_Failed is raised with the Diagnosis string set as
   --        "No Asis_Element corresponds to the node "
   --      &  Node_Id'Image (Node)
   --      &  " ("
   --      &   Node_Kind'Image (Nkind (Node))
   --      &  ')' ;
--   ###

   function N_Operator_Symbol_Mapping
     (Node : Node_Id)
      return Internal_Element_Kinds;
   --  This is one of the local functions of the package body made visible
   --  for using in the implementation of the Asis.Expressions.Prefix
   --  function.
   --
   --  ?? Is it a really good approach?? Swould we try to get rid of it?

   function N_Attribute_Reference_Mapping
     (Node : Node_Id)
     return Internal_Element_Kinds;
   --  This is one of the local functions of the package body made visible
   --  for using in the implementation of the Asis.Text.
   --
   --  ?? Is it a really good approach?? Swould we try to get rid of it?

   function Subprogram_Attribute_Kind
     (Node : Node_Id)
      return Internal_Element_Kinds;
--------------------------------------------------------------------------
--
--  Node - The Node in the AST
--
--  This function defines the kind of an Element which can be built on
--  N_Attribute_Reference node corresponding to a reference to
--  attribute-subprogram, but opposite to the general attribute kind
--  determinition implemented by N_Attribute_Reference_Mapping, it does not
--  classiby an Elemen as a function or a procedure call, but it defines the
--  corresponding Attribute_Kinds value.
--------------------------------------------------------------------------

   function Node_To_Element
     (Node                           : Node_Id;
      Special_Case                   : Special_Cases := Not_A_Special_Case;
      Taking_Account_Of_Parent_Count : Boolean := True;
      Check_If_Type_Conversion       : Boolean := True;
      In_Unit                        : Asis.Compilation_Unit)
      return Asis.Element;
--------------------------------------------------------------------------
--
--  Node    - The Node in the AST, which the corresponding Asis Element
--            should be constructed for
--
--  Special_Case  - The Special_Cases value for the Asis Element
--                  being constructed. Usially Not_A_Special_Case default is
--                  used except when the predefined package Standard is
--                  processed, but - who knows...
--
--  Taking_Account_Of_Parent_Count - boolean flag indicating if the
--            value of the Parent_Count field of the Node should be
--            taken into account for the definition of the kind
--            of the Asis Element to be returned by the function.
--            Is important for constructing the elements of An_Expression
--            subordinate kinds only. Usially set ON, the exceptions are
--            the functions Expression_Parenthesized,
--            Converted_Or_Qualified_Expression and ??? from
--            Asis_Expressions.
--
--  Check_If_Type_Conversion - boolean flag indicating if for a node which
--      has the Original_Node of N_Attribute_Reference kind
--           corresponding to 'Base or 'Class attribute the check should
--      be made if this pair of the original and rewritten nodes
--      corresponds to A_Type_Conversion Element. This flag should
--      be set OFF when constructing the Element for a subtype mark
--      which is a child element of A_Type_Conversion Element
--      (function Asis_Expressions.???)
--
--  In_Unit - The Asis Compilation Unit, to which the Element being
--            constructed belongs
--
--  Constructs the Asis.Element value on the base of the tree Node.
--
--  The Node_Id value passed by the Node parameter is used to initialize
--  the corresponding field of the result. It means that the proper
--  AST node for the Asis.Element construction should be determined
--  in the callind context and passed in this function to be used in
--  the Element construction WITHOUT ANY CHANGE!!!!!!!!!!!!!!!
--
--  If no Asis.Element could be constructed for the given node, or if the
--  corresponding element of the GNAT AST -> Asis.Elements mapping has
--  not been implemented yet, the corresponding Asis exception is to be
--  raised by the Asis_Internal_Element_Kind, which is called by this
--  function (see corresponding documentations items above).
--
--  Additional constrains for the arguments should be defided later, when
--  the body of the function is designed in more details
--------------------------------------------------------------------------

   function Node_To_Element
     (Node          : Node_Id;
      Internal_Kind : Internal_Element_Kinds;
      Special_Case  : Special_Cases := Not_A_Special_Case;
      In_Unit       : Asis.Compilation_Unit)
      return Asis.Element;
--------------------------------------------------------------------------
--
--  Node          - The Node in the AST, which the corresponding
--                  Asis Element should be constructed for
--
--  Internal_Kind - The Internal Element Kind value for the Asis Element
--                  being constructed
--
--  In_Unit -       The Asis Compilation Unit, to which the Element
--                  being constructed belongs
--
--  Special_Case  - The Special_Cases value for the Asis Element
--                  being constructed
--
--  Constructs the Asis.Element value on the base of the tree Node.
--
--  This function is the specialized version of the previous Node_To_Element
--  function with two parameters intended to be used in trivial/special
--  cases when the Internal Element Kind of the element being constructed is
--  known for sure before the construction, it also could be used for
--  constructing the element which has to have something different than
--  Not_A_Special_Case as the value of its Special_Case field (for example,
--  for constructing the dummy block statement rturned by the
--  Declarations.Body_Block_Statement function.
--
--  The Node_Id value passed by the Node parameter is used to initialuse
--  the corresponding field of the result. It means that the proper
--  AST node for the Asis.Element construction shoild be determined
--  in the callind context and passed in this function to be used in
--  the Element construction WITHOUT ANY CHANGE!!!!!!!!!!!!!!!
--
--  Additional constrains for the arguments should be defided later, when
--  the body of the function is designed in more details
--------------------------------------------------------------------------

   ------------------------------------------------
   -- Node-to-Element conversion - the new stuff --
   ------------------------------------------------

   --  This section contains the new function (functions???) for the
   --  Node-to-Element conversion. The idea is to have a function which
   --  would be able to work with both explicit and implicit Elements,
   --  as well as with the results of generic expansions

   function Node_To_Element_New
     (Node                     : Node_Id;
      Node_Field_1             : Node_Id                := Empty;
      Starting_Element         : Asis.Element           := Asis.Nil_Element;
      Internal_Kind            : Internal_Element_Kinds := Not_An_Element;
      Spec_Case                : Special_Cases          := Not_A_Special_Case;
      Considering_Parent_Count : Boolean                := True;
      Using_Original_Node      : Boolean                := True;
      Inherited                : Boolean                := False;
--      Check_If_Type_Conversion       : Boolean                := True;
      In_Unit          : Asis.Compilation_Unit  := Asis.Nil_Compilation_Unit)
      return Asis.Element;
   --  this functions creates the ASIS Element which could be built on the
   --  basis of Node. Its other parameters have the following meaning (the
   --  wording "the parameter is set" means below that some non-nil value
   --  is explicitly passed in the function call):
   --
   --  Starting_Element - if this parameter is set, the following fields
   --     of the result Element are set as being equial to the corresponding
   --     fields of Starting_Element:
   --
   --     -  Enclosing_Unit (unless the In_Unit parameter is set);
   --     -  Enclosing_Context (unless the In_Unit parameter is set);
   --     -  Is_Part_Of_Implicit;
   --     -  Is_Part_Of_Inherited;
   --     -  Is_Part_Of_Instance;
   --     -  Special_Case (unless the Special_Case parameter is set);
   --     Setting Starting_Element as being equial to the argument Element
   --     of the ASIS query where Node_To_Element to form the result of the
   --     query is the common case for the ASIS structural queries
   --
   --     If Starting_Element is not set, the corresponding fields are
   --     determined by the function from Node.
   --
   --  Internal_Kind - if this parameter is set, its value is set as the
   --     value of the Internal_Kind field of the result Element. Otherwise
   --     the kind of the result Element is determined automatically
   --
   --  Spec_Case  - if this parameter is set, its value is set as the
   --     value of the Special_Case field of the result Element. Otherwise
   --     the value of the Special_Case field of the result Element is set
   --     from Starting_Element, if Starting_Element itself is set, or as
   --     being equial to Not_A_Special_Case, if Starting_Element is not set.
   --
   --  Considering_Parent_Count - boolean flag indicating if the
   --     value of the Parent_Count field of the Node should be
   --     taken into account for the definition of the kind
   --     of the Asis Element to be returned by the function.
   --     Is important for constructing the elements of An_Expression
   --     subordinate kinds only. Usially set ON, the exceptions are
   --     the functions Expression_Parenthesized,
   --     Converted_Or_Qualified_Expression and ??? from
   --     Asis.Expressions.
   --
   --  Using_Original_Node - boolean flag indicating if the original node
   --     should be used as the basis of the Element being constructed.
   --     Usially the default True is used, but sometimes we have to
   --     avoid using the original node, for example, when constructing the
   --     expanded spec for a generic instantiation in case of a library_item
   --
   --  Inherited - bolean flag indicationg if the element being constructed
   --     represents a declaration of an implicit inherited subprogram or a
   --     subcomponent thereof.
   --     ??? why do we need it???
--   --
--   --  Check_If_Type_Conversion - boolean flag indicating if for a node which
--   --     has the Original_Node of N_Attribute_Reference kind
--   --     corresponding to 'Base or 'Class attribute the check should
--   --     be made if this pair of the original and rewritten nodes
--   --     corresponds to A_Type_Conversion Element. This flag should
--   --     be set OFF when constructing the Element for a subtype mark
--   --     which is a child element of A_Type_Conversion Element
--   --     (function Asis.Expressions.Converted_Or_Qualified_Subtype_Mark)
   --
   --  In_Unit - The Asis Compilation Unit, to which the Element being
   --     constructed belongs. It is an error not to set both Starting_Element
   --     and In_Unit parameters. If both of them are set, the value of
   --     the Enclosing_Unit and Enclosing_Context fields of the result
   --     Element are set from In_Unit
   --
   --  NOTE, that if Starting_Element is NOT set, the Is_Part_Of_Implicit and
   --  the Is_Part_Of_Inherited fields  of  the result are set off (equial to
   --  False), therefore the caller (that is, the implementation of the
   --  corresponding ASIS query) is responsible for correct setting of these
   --  fields. As for the Is_Part_Of_Instance field, it is set on the base of
   --  Sloc field of the corresponding Node.
   --
   --  Now this is a TEMPORARY SOLUTION. If we decide to keep this as a rule,
   --  the documentaion should be changed.
   --
   --  We do not expect an Empty node to be passed in this function as the
   --  actual for the Node parameter. But if it is passed, the result of the
   --  function is Nil_Element, independently of all the other
   --  parameters (passing an Empty node to this function looks like a bug).

   --  OPEN PROBLEMS:
   --
   --  1. The general idea is to replace all calls to the old Node_To_Element
   --     functions by the calls to this new function. The name
   --     Node_To_Element_New is a (not very nice) compromise for this
   --     transition period
   --
   --  2. Do we need parameters Taking_Account_Of_Parent_Count and
   --     Check_If_Type_Conversion (commented out for now) in the
   --     Node-to-Element convertor? In fact, they are used in a single
   --     query each: Taking_Account_Of_Parent_Count - in
   --     Asis.Expressions.Expression_Parenthesized; and
   --     Check_If_Type_Conversion - in
   --     Asis.Expressions.Converted_Or_Qualified_Subtype_Mark.
   --     It would make sense to provide the special code for these two
   --     queries instead of having these two additional parameters for
   --     the Node-to-Element convertor used by almost all queries.

   ---------------------------------------------------------
   -- End of the new stuff for Node-to-Element conversion --
   ---------------------------------------------------------


--------------------------------------------------------------------------
--               NODE LISTS TO ELEMENT LISTS CONSTRUCTORS
--------------------------------------------------------------------------

   --------------------------------------------------------------
   -- NODE LISTS TO ELEMENT LISTS CONSTRUCTORS - The new stuff --
   --------------------------------------------------------------

   function N_To_E_List_New
     (List             : List_Id;
      Include_Pragmas  : Boolean                := False;
      Starting_Element : Asis.Element           := Asis.Nil_Element;
      Node_Knd         : Node_Kind              := N_Empty;
      Internal_Kind    : Internal_Element_Kinds := Not_An_Element;
      Special_Case     : Special_Cases          := Not_A_Special_Case;
      In_Unit          : Asis.Compilation_Unit  := Asis.Nil_Compilation_Unit)
      return Asis.Element_List;
   --  This is a general function converting a tree Node list into the
   --  corresponding ASIS Element List. Now we have far too many
   --  functions for converting node lists into Element lists.
   --  The idea is to replase all the other functions by this
   --  function
   --
   --  The parameters have the following meaning (we say "if the parameter
   --  is set" with the meaning "if some actual different from the default
   --  nil value is passed for the parameter")
   --
   --    List - specifies the tree node list to be converted into
   --           ASIS Element List;
   --
   --    Include_Pragmas - boolean flags sighifying if pragmas should be
   --           included in the result list;
   --
   --    Node_Knd - if this parameter is set, only those nodes from List
   --           which have this node kind are used to construct Elements in
   --           the result Element List;
   --
   --    Internal_Kind - if this parameter is set, all the Elements of the
   --           result list are set having this kind, otherwise the kind
   --           of each element of the result list is determined
   --           automatically;
   --
   --    Special_Case  - if this parameter is set, all the Elements of the
   --           result list are set having this special case;
   --
   --    Starting_Element - the following fields of all the Elements in
   --           the result Element List are set as being equial to the
   --           corresponding fields of Starting_Element:
   --             -  Enclosing_Unit (unless the In_Unit parameter is set);
   --             -  Enclosing_Context (unless the In_Unit parameter is set);
   --             -  Is_Part_Of_Implicit;
   --             -  Is_Part_Of_Inherited;
   --             -  Is_Part_Of_Instance;
   --             -  Special_Case (unless the Special_Case parameter is set);
   --           Setting Starting_Element as being equial to the argument
   --           Element of the ASIS query where N_To_E_List is called
   --           to form the result of the query is the common case for the
   --           ASIS structural queries
   --
   --    In_Unit - The Asis Compilation Unit, to which the Elements being
   --           constructed belong. It is an error not to set both
   --           Starting_Element and In_Unit parameters. If both of them
   --           are set, the value of the Enclosing_Unit and
   --           Enclosing_Context fields of the result Elements are set
   --           from In_Unit

   function Defining_Id_List_From_Normalized
     (N : Node_Id;
      From_Declaration : Asis.Element)
      return Asis.Defining_Name_List;
   --  This function constructs an (ASIS) list of A_Defining_Identifier
   --  ASIS Elements from a normalized seqience of one-identified
   --  declarations or specifications. N should be of one of the
   --  following kinds:
   --    N_Object_Declaration
   --    N_Number_Declaration
   --    N_Discriminant_Specification
   --    N_Component_Declaration
   --    N_Parameter_Specification
   --    N_Exception_Declaration
   --    N_Formal_Object_Declaration
   --  This function is intended to be used in the implementation of
   --  Asis.Declarations.Names query

   --------------------------------------------------------------------
   -- NODE LISTS TO ELEMENT LISTS CONSTRUCTORS - The new stuff - END --
   --------------------------------------------------------------------

--  Functions for the construction of the Asis.Element_List on the base
--  of GNAT AST Node or Entity (?) List are defined in this subsection
--
--  A number of different kinds of the Node_List -> Asis.Element_List
--  mappings exist. Many of them can be described by the condition
--  defining for which nodes in the Node List the corresponding Asis
--  Elements should be constructed and included in the returned
--  Asis.Element_List.
--
--  According to ASIS Representations for Implicit Constructs defined
--  in the ASIS: Detailed Semantics and Implementation Document for
--  the ASIS 1.1.1, the Node -> Element Lists constuctors used by
--  all Asis interfaces except having the word "Implicit" in the
--  function definind designator should construct the elements of the
--  returned Element Lists on the base of the Tree Nodes corresponding
--  to the EXPLICIT elements of the Compilation Units only. The initial
--  idea was to use the Comes_From_Source flag to select the "explicit"
--  Nodes by means of the
--
--         if Comes_From_Source (Node) then
--             ...
--  filtering. But it is impossible now, because this flag is not set
--  properly for the most of the Node_Kind values - see Atree.ads
--
--  Another idea for the filtering the tree Nodes corresponding to the
--  explicit constructs from the Ada sources is to use the Rewrite_Sub
--  and Rewrite_Ins flags, see Atree.ads:
--
--    --   Rewrite_Sub      A flag set if the node has been rewritten using
--    --                    the Rewrite_Substitute_Tree procedure. The original
--    --                    value of the node is retrievable with
--                          Original_Node.
--
--    --   Rewrite_Ins      A flag set if a node is marked as a rewrite
--                          inserted node as a result of a call to
--                          Mark_Rewrite_Insertion.
--
--  THE FIRST PROTOTYPE APPROACH IS:
--
--  (1) The Base Node Filter:
--
--      If Is_Rewrite_Insertion (Node) = True then it is very likely
--      that the Node corresponds to some Implicit Construct either
--      existing in the Ada Compilation Unit or being incerted by GNAT
--      front-end for its internal purposes. So the base filter for
--      filtering out the implicit construct is
--
--          if no Is_Rewrite_Insertion (Node) then
--              ...
--
--  (2) If Is_Rewrite_Substitution (Node) = True then it is very likely
--      that the Node has been modified during the semantic analysis, and
--      it is very likely that the Original_Node function should be used
--      to obtain the original Node to construct the corresponding
--      Asis Element, but iy may require additional non-trivial analysis
--      depending on the particular Node. So the
--
--          if no Is_Rewrite_Substitution (Node) then
--              ...
--       construction cannot be used as a filter for "implicit" Nodes.
--
--  (3) Questions/Hypotheses
--
--      Both points (1) and (2) above require additional checking and
--      analysis - so they are no more than hypotheses.
--
--      Additional hypotheses are:
--
--      (3.1) Its impossible for a Node to have both flags Rewrite_Sub
--            and Rewrite_Ins being set on.
--
--      (3.2) If the Node has been obtained as the result of the
--            Original_Node function, than for this Node
--               Is_Rewrite_Insertion (Node) = False
--            and
--               Is_Rewrite_Substitution (Node) = False
--
--      (3.3) If Original_Node (Node) = Node then
--
--               this means that the Node corresponds to some
--               explicit construction presenting in the Ada
--               source text
--
--            eisif Original_Node (Node) = Empty then
--
--               this means that the node  corresponds to some
--               implicit construct, or, in other words,
--               Original_Node (Node) = Empty if and only if
--               Is_Rewrite_Insertion (Node) = True
--
--            else
--
--               the Node has been modified during semantic analysis
--               phase, and the result of the Original_Node (Node)
--               call is required for further analysis and Asis
--               Element construction
--
--            end if;
--
--      (3.4) If the Node has been consrtucted by parser,
--            then for this Node
--               Is_Rewrite_Insertion (Node) = False
--            and
--               Is_Rewrite_Substitution (Node) = False
--
--      (3.5) If the node has been constructed by parser, it does
--            not necessary mean that this Node corresponds to some
--            explicit construct coming from the source!
--
--  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
--  The first experience of the trying to follow this approach is
--  rather awkward :-(
--  It seems that hypotheses from the point (3) above are wrong
--  So some ad hoc approaches are used to construct the first
--  prototype code.
--  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
--
--
--  REQUIRED COMPLETITION???
--
--  LIST CONSTRUCTORS SHOULD BE REVISED!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
--------------------------------------------------------------------------
--       NODE LISTS TO ELEMENT LISTS CONSTRUCTORS - TRIVIAL CASES
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- !! NODE LISTS TO ELEMENT LISTS CONSTRUCTORS part definitely       !! --
-- !! should be revised! Do we really need the function having the   !! --
-- !! parameter for Inclusion Condition??? It looks that it would be !! --
-- !! enough to have two functions - one which includes pragmas, and !! --
-- !! another which does not.                                        !! --
--------------------------------------------------------------------------

   function N_To_E_List_Without_Pragmas
     (List    : List_Id;
      In_Unit : Asis.Compilation_Unit)
      return Asis.Element_List;
   --  Converts the tree node list into ASIS Element list. All the pragmas
   --  included in the argument node list are skipped and the corresponding
   --  ASIS A_Pragma Elements are not included into the result Element List.
   --
   --  The kinds of Elements in the result Element list are automatically
   --  defined from the corresponding tree structures.

   function N_To_E_List_Without_Pragmas
     (List          : List_Id;
      Internal_Kind : Internal_Element_Kinds;
      Special_Case  : Special_Cases := Not_A_Special_Case;
      In_Unit       : Asis.Compilation_Unit)
      return Asis.Element_List;
   --  The modification of the previous N_To_E_List_Without_Pragmas function
   --  which allows to set the kind and the special case of the members
   --  of the result ASIS Element List explicitly. No automatic determination
   --  of the kinds of the members of the result list is parformed
   --
   --  Only those tree nodes which correspond to the explicit
   --  (= Comes_From_Source) constructs are converted to Elements to be
   --  included into the result list

   function N_To_E_List_Without_Pragmas
     (List          : List_Id;
      Node_Knd      : Node_Kind;
      Internal_Kind : Internal_Element_Kinds;
      Special_Case  : Special_Cases := Not_A_Special_Case;
      In_Unit       : Asis.Compilation_Unit)
      return Asis.Element_List;
   --  Another modification of the first N_To_E_List_Without_Pragmas function.
   --  The difference with the first modification is that all the node list
   --  members having the Node Kind passed as an actual for Node_Knd are
   --  converted into Elements and then these Elements are included in the
   --  result list, regardless of the value of the Comes_From_Source flag

   function N_To_E_List_With_Pragmas
     (List    : List_Id;
      In_Unit : Asis.Compilation_Unit)
      return Asis.Element_List;
   --  Converts the tree node list into ASIS Element list. All the pragmas
   --  included in the argument node list are converted into ASIS A_Pragma
   --  Elements and are included into the result Element List.
   --
   --  The kinds of Elements in the result Element list are automatically
   --  defined from the corresponding tree structures.

   function Node_To_Element_List
     (List    : List_Id;
      In_Unit : Asis.Compilation_Unit)
      return Asis.Element_List;
--------------------------------------------------------------------------
--
--  List    - The Node List in the AST, which the corresponding Asis Element
--            List should be constructed for
--
--  In_Unit - The Asis Compilation Unit, to which the Element of the
--            Element List being constructed belong.
--
--  Constructs the Asis.Element_List value on the base of the tree Node List.
--  The only condition for constructing the Asis Element on the base of the
--  particular Tree Node (and including the constructed element in the
--  returned list) is that this Node should correspond to the explicit
--  construct

--------------------------------------------------------------------------

   function Node_To_Element_List
     (List          : List_Id;
      Internal_Kind : Internal_Element_Kinds;
      In_Unit : Asis.Compilation_Unit)
      return Asis.Element_List;
--------------------------------------------------------------------------
--
--   List          - The Node List in the AST, which the corresponding Asis
--                   Element  List should be constructed for
--
--   Internal_Kind - Internal kind of the Elements of result list
--
--   In_Unit       - The Asis Compilation Unit, to which the Elements of the
--                   Element List being constructed belong.
--
--  Constructs the Asis.Element_List value on the base of the tree Node List.
--  The only condition for constructing the Asis Element on the base of the
--  particular Tree Node (and including the constructed element in the
--  returned list) is that this Node should correspond to the explicit
--  construct. All Elements in the result list have the Internal_Kind
--  value defined by the Internal_Kind parameter.
--
--  This function is intended to be used when some homogeneous Element_List
--  is to be constructed on the base of heterogeneous Node List,
--  for example, some association list.


--------------------------------------------------------------------------
--       NODE LISTS TO ELEMENT LISTS CONSTRUCTORS - SPECIAL CASES
--------------------------------------------------------------------------

   function Statements_Node_To_Element_List
     (Statements_Seq  : Node_Id;
      Include_Pragmas : in Boolean := False;
      Starting_Element : Asis.Element := Asis.Nil_Element)
      return Asis.Element_List;
--------------------------------------------------------------------------
--  ??? We should get rid of this function and use N_ToEl_List_New instead!!!
--
--  Statements_Seq  - The Node in the AST, which Node Kind should be
--                    N_Handled_Sequence_Of_Statements. For this node
--                    the corresponding Asis Element List contained
--                    statements from this Handled Sequence Of
--                    Statements should be constructed for.
--
--  Include_Pragmas - Specifies True if embedded pragmas are to be used
--                    for the construction of the Elements to be included
--                    in the resulting list
--
--  In_Unit -         The Asis Compilation Unit, to which the Element of
--                    the Element List being constructed belong.
--
--  Constructs the Asis.Element_List value on the base of the tree Node.
--
--  This function is a special variant of the Node_To_Element_List function
--  taking account of the percularities of the
--  N_Handled_Sequence_Of_Statements nodes, as these nodes are described
--  in the Sinfo package:
--
      ------------------------------------------
      -- 11.2  Handled Sequence Of Statements --
      ------------------------------------------

      --  HANDLED_SEQUENCE_OF_STATEMENTS ::=
      --      SEQUENCE_OF_STATEMENTS
      --    [exception
      --      EXCEPTION_HANDLER
      --      {EXCEPTION_HANDLER}]
      --    [at end
      --      cleanup_procedure_IDENTIFIER;]

      --  The AT END phrase is a GNAT extension to provide for cleanups. It is
      --  used only internally currently, but is considered to be syntactic.
      --  At the moment, the only cleanup action allowed is a single call to
      --  a parameterless procedure, and the Identifier field of the node is
      --  the procedure to be called. Also there is a current restriction
      --  that exception handles and a cleanup cannot be present in the same
      --  frame, so at least one of Exception_Handlers or the Identifier must
      --  be missing.

      --  The AT END cleanup handler protects only the sequence of statements
      --  (not the associated declarations of the parent), just like exception
      --  handlers. The big difference is that the cleanup procedure is called
      --  on either a normal or an abnormal exit from the statement sequence.

      --  Note: although in the Ada syntax, the sequence of statements can
      --  only contain statements, at the tree level, it is fine to mix in
      --  declarations into this statement sequence. This is used in some
      --  cases where a cleanup procedure is required to cover declarations
      --  as well as statements.

      --  N_Handled_Sequence_Of_Statements
      --  Sloc points to first token of first statement
      --  Statements (List3)
      --  Exception_Handlers (List4) (set to No_List if none present)
      --  Identifier (Node1) (set to Empty if no clean up procedure)
      --  First_Real_Statement (Node2-Sem)

      --  Note: the parent always contains a Declarations field which contains
      --  declarations associated with the handled sequence of statements. This
      --  is true even in the case of an accept statement (see description of
      --  the N_Accept_Statement node).
--
--  This function returns Asis.Element_List containing Elements for
--  statements (and pragmas appear in the original SEQUENCE_OF_STATEMENTS
--  only)
--
--  Constrains for the arguments should be defided later, when the body
--  of the function is designed in more details

--------------------------------------------------------------------------
   function Discrete_Choice_Node_To_Element_List
     (Choice_List : List_Id;
      In_Unit     : Asis.Compilation_Unit)
      return Asis.Element_List;
--------------------------------------------------------------------------
--
--   Choice_List - The List_Id value containing the reference to the list of
--                 the discrete choices (obtained as the result of the
--                 Sinfo.Discrete_Choices function). Any call of this function
--                 for the other node lists is erroneous.
--
--   In_Unit -     The Asis Compilation Unit, to which the Element of
--                 the Element List being constructed belong.
--
--  Constructs the Asis.Element_List value on the base of the given Node List.
--
--  This function is a special variant of the Node_To_Element_List function
--  constructing the list of the ASIS images of the discrete choices. It is
--  intendded to be used in the implementation of the
--           Asis_Statements.Case_Statement_Alternative_Choices
--  and
--           Asis_Definitions.Variant_Choices
--  function; the function Asis_Expressions.Component_Choices should also
--  be considered as the potential application field for this function.
--------------------------------------------------------------------------
--------------------------------------------------------------------------
--       NODE LISTS TO ELEMENT LISTS CONSTRUCTORS - GENERAL CASE
--------------------------------------------------------------------------

   type Inclusion_Condition is access
      function (Node : Node_Id) return Boolean;
--
--  The values of this type point to the functions describing the conditions
--  for the inclusion of the Asis Element constructed on the base of this
--  Node in the Element List.
--------------------------------------------------------------------------

   function Node_To_Element_List
     (List           : List_Id;
      In_Unit        : Asis.Compilation_Unit;
      To_Be_Included : Inclusion_Condition)
      return Asis.Element_List;
--------------------------------------------------------------------------
--
--  List           - The Node List in the AST, which the corresponding
--                   Asis Element List should be constructed for
--
--  To_Be_Included - Spesifies function defining the condition the node
--                   should saticfy to be used for the construction of
--                   the corresponding ASIS Elements to be included
--                   in the ASIS Element List returned by the function
--
--  In_Unit -        The Asis Compilation Unit, to which the Element of
--                   the Element List being constructed belong.
--
--  The general-purpose Tree Node List -> Asis.Element_List constructor.
--  Only Nodes for which the To_Be_Included function yield True
--  (after having been filtered as non-corresponding to implicit
--  construct by the base node filter, see above) are
--  used to construct Asis Elements to be included in the resulting Asis
--  Element_List, all other Nodes in the List are skipped.
--
--  Constrains for the arguments should be defided later, when the body
--  of the function is designed in more details
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Inclusion conditions:
--------------------------------------------------------------------------

   function Every_Node (Node : Node_Id) return Boolean;

--  Trivial condition: every Node should be included
--------------------------------------------------------------------------

   function No_Pragma (Node : Node_Id) return Boolean;

--  Pragmas should not be included in the returned list.
--------------------------------------------------------------------------

   function Only_Pragmas (Node : Node_Id) return Boolean;

--  Only Pragmas should be included in the returned list.

--------------------------------------------------------------------------

--------------------------------------------------------------------------
--     PART TWO: OBTAINING THE STRING REPRESENTATION FOR THE NODE
--               CONTAINING THE CHARS FIELD.
--------------------------------------------------------------------------
--
   function Namet_String (Node : Node_Id) return String;

--  Retrurns the string representation of the Node on the base of the
--  information contained in Name Table and obtained by the value of the
--  Chars field of the Node.

   function Namet_String (Name : Name_Id) return String;
--  does just the same as the previous function, but gets the ready-to-use
--  reference to the Name Table as the argument.

   function Normalized_Namet_String (Node : Node_Id) return String;

--  Does the same as the previous function, and then "normalizes" the
--  result by capitalizing the first letter and every letter after
--  underscore

--  These two functions are intended to be used to get the string
--  representation of the components of the predefined Standard package,
--  which does not have its source contained in the Source Buffer
--

   function Ureal_Image (N : Node_Id) return String;
   --  Returns the string representation of a value represented by an
   --  N_Real_Literal node. The returned format is not very smart, but who
   --  cares?

--------------------------------------------------------------------------
end A4G.Mapping;