#include "testsuite.h"
#include <blitz/array.h>

BZ_USING_NAMESPACE(blitz)

// When an array is created from a pre-existing block of data,
// makeUnique() should force a copy of the data.

int main() 
{
  double a[] = {1.2, 2.2};

  Array<double, 1> b(a, shape(2));

  BZTEST(b.data() == a);
  
  b.makeUnique();

  BZTEST(b.data() != a);

  return 0;
}

