# $Id: camlp4.spec,v 1.3 1999/11/20 03:50:28 ddr Exp $

Name: camlp4
Version: 2.03
Release: 1
Packager: Daniel de Rauglaudre <daniel.de_rauglaudre@inria.fr>
Summary: Objective Caml Preprocessor
Source0: ftp://ftp.inria.fr/INRIA/Projects/cristal/Daniel.de_Rauglaudre/Camlp4/camlp4-%{version}.tar.gz
Source1: ftp://ftp.inria.fr/INRIA/Projects/cristal/Daniel.de_Rauglaudre/Camlp4/camlp4-%{version}.html.tar.gz
Source2: ftp://ftp.inria.fr/INRIA/Projects/cristal/Daniel.de_Rauglaudre/Camlp4/camlp4-%{version}.ps.gz
Copyright: BSD
Group: Development/Languages
Vendor: INRIA Rocquencourt
URL: http://caml.inria.fr/
BuildRoot: /tmp/caml-root
Requires: ocaml = 2.03

%description
Camlp4 is a Pre-Processor-Pretty-Printer for Objective Caml. It offers tools 
for syntax (grammars) and the ability to modify the concrete syntax 
of the language (quotations, syntax extensions). 

Camlp4 can parse normal Ocaml concrete syntax or any other user-definable
syntax. As an example, an alternative syntax is provided, named revised,
because it tries to fix some small problems of the normal syntax. 

Camlp4 can pretty print the normal Ocaml concrete syntax or the revised one.
It is therefore always possible to have a version of your sources compilable
by the compiler Objective Caml without preprocessing. 

%changelog
* Tue Sep  7 1999 Daniel de Rauglaudre <daniel.de_rauglaudre@inria.fr>
Version 2.01.1 Release 1
- Created from Alexey Nogin's Camlp4 spec file

%prep
%setup -q -T -b 0
%setup -q -T -D -a 1
mv camlp4-%{version}.html manual
cp %{SOURCE2} refman.ps.gz

%build
(
echo OLIBDIR=/usr/lib/ocaml
echo BINDIR=/usr/bin
echo LIBDIR=/usr/lib/camlp4
echo MANDIR=/usr/man/man1
) > config/Makefile.cnf

rm -f config/Makefile
cat config/Makefile.tpl > config/Makefile
echo >> config/Makefile
cat config/Makefile.cnf >> config/Makefile
chmod -w config/Makefile
make world opt

%install
(
echo OLIBDIR=$RPM_BUILD_ROOT/usr/lib/ocaml
echo BINDIR=$RPM_BUILD_ROOT/usr/bin
echo LIBDIR=$RPM_BUILD_ROOT/usr/lib/camlp4
echo MANDIR=$RPM_BUILD_ROOT/usr/man/man1
) > config/Makefile.cnf

rm -f config/Makefile
cat config/Makefile.tpl > config/Makefile
echo >> config/Makefile
cat config/Makefile.cnf >> config/Makefile
chmod -w config/Makefile
rm -rf $RPM_BUILD_ROOT
make install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr (-,root,root)
/usr/bin/camlp4
/usr/bin/camlp4o
/usr/bin/camlp4r
/usr/bin/mkcamlp4
/usr/bin/ocpp
/usr/bin/odyl
/usr/lib/camlp4
/usr/man/man1/camlp4.1
/usr/man/man1/camlp4r.1
/usr/man/man1/camlp4o.1
/usr/man/man1/ocpp.1
/usr/man/man1/mkcamlp4.1
%doc refman.ps.gz manual LICENSE CHANGES README README-2.01
