use Language::INTERCAL;
use Language::INTERCAL::Runtime::Library;

my $src = '
@z@L`@{
@M]@
@@@z
@@
M]@@z@L`@{
@M]@
@@
M]@@z@L`@{
@@{
@@{
';

print "1..42\n";

fiddle Language::INTERCAL 'bug=0', 'ubug=0';

compile Language::INTERCAL 'lose', $src;
compile Language::INTERCAL 'lose_o', $src, 'opt';
compile Language::INTERCAL 'lose_q', $src, 'quantum';
compile Language::INTERCAL 'lose_p', $src, 'post';
compile Language::INTERCAL 'lose_qp', $src, 'quantum', 'post';
compile Language::INTERCAL 'lose_d', $src, 'dbhook';

fiddle Language::INTERCAL 'next';
compile Language::INTERCAL 'prog', $src;
compile Language::INTERCAL 'prog_o', $src, 'opt';
compile Language::INTERCAL 'prog_q', $src, 'quantum';
compile Language::INTERCAL 'prog_p', $src, 'post';
compile Language::INTERCAL 'prog_qp', $src, 'quantum', 'post';
compile Language::INTERCAL 'prog_d', $src, 'dbhook';

eval { lose(0, 0) };
print $@ =~ /401 YOUR PROGRAM IS OBSOLETE/ ? "" : "not ", "ok 1\n";

eval { lose_o(0, 0) };
print $@ =~ /401 YOUR PROGRAM IS OBSOLETE/ ? "" : "not ", "ok 2\n";

eval { lose_q(0, 0) };
print $@ =~ /401 YOUR PROGRAM IS OBSOLETE/ ? "" : "not ", "ok 3\n";

eval { lose_p(0, 0) };
print $@ =~ /401 YOUR PROGRAM IS OBSOLETE/ ? "" : "not ", "ok 4\n";

eval { lose_qp(0, 0) };
print $@ =~ /401 YOUR PROGRAM IS OBSOLETE/ ? "" : "not ", "ok 5\n";

_run_db(lose_d(0, \&foo));
print $@ =~ /401 YOUR PROGRAM IS OBSOLETE/ ? "" : "not ", "ok 6\n";

my @foo;

@foo = ();
eval { prog(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 7\n";
print @foo == 1 ? "" : "not ", "ok 8\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 9\n";

@foo = ();
eval { prog_o(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 10\n";
print @foo == 1 ? "" : "not ", "ok 11\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 12\n";

@foo = ();
eval { prog_q(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 13\n";
print @foo == 1 ? "" : "not ", "ok 14\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 15\n";

@foo = ();
eval { prog_p(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 16\n";
print @foo == 1 ? "" : "not ", "ok 17\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 18\n";

@foo = ();
eval { prog_qp(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 19\n";
print @foo == 1 ? "" : "not ", "ok 20\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 21\n";

@foo = ();
_run_db(prog_d(0, \&foo));
print STDERR $@;
print $@ ? "not " : "", "ok 22\n";
print @foo == 1 ? "" : "not ", "ok 23\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 24\n";

@foo = ();
eval { lose(0, \&foo, {'next' => 1}) };
print STDERR $@;
print $@ ? "not " : "", "ok 25\n";
print @foo == 1 ? "" : "not ", "ok 26\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 27\n";

@foo = ();
eval { lose_o(0, \&foo, {'next' => 1}) };
print STDERR $@;
print $@ ? "not " : "", "ok 28\n";
print @foo == 1 ? "" : "not ", "ok 29\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 30\n";

@foo = ();
eval { lose_q(0, \&foo, {'next' => 1}) };
print STDERR $@;
print $@ ? "not " : "", "ok 31\n";
print @foo == 1 ? "" : "not ", "ok 32\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 33\n";

@foo = ();
eval { lose_p(0, \&foo, {'next' => 1}) };
print STDERR $@;
print $@ ? "not " : "", "ok 34\n";
print @foo == 1 ? "" : "not ", "ok 35\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 36\n";

@foo = ();
eval { lose_qp(0, \&foo, {'next' => 1}) };
print STDERR $@;
print $@ ? "not " : "", "ok 37\n";
print @foo == 1 ? "" : "not ", "ok 38\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 39\n";

@foo = ();
_run_db(lose_d(0, \&foo, {'next' => 1}));
print STDERR $@;
print $@ ? "not " : "", "ok 40\n";
print @foo == 1 ? "" : "not ", "ok 41\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 42\n";

sub foo {
    push @foo, join('', @_);
}

