# this program converts EBCDIC text to ASCII; the test succeeds if the
# program's source gets correctly converted. Just running &converter after
# the "compile" would convert EBCDIC from STDIN and produce ASCII on STDOUT.

use Language::INTERCAL;
use Language::INTERCAL::Runtime::Library;
use Charset::EBCDIC;

my @src = split(/\n/, <<EOF);
    DO ,1 <- #1024
    PLEASE COME FROM (1)
    DO WRITE IN ,1
    DO .1 <- V',1 SUB #1' ~ #21865
    DO .1 <- .V1 ~ #85
    DO .1 <- .V1 ~ #5
    DO .1 <- .V1 ~ #1
(2) DO :1 <- .1  #0
    PLEASE GIVE UP
    PLEASE COME FROM :1
(1) DO READ OUT ,1
EOF

my @converter = map { ascii2ebcdic($_) } @src;

fiddle Language::INTERCAL 'bug=0', 'ubug=0';

my $converter = join("\n", @converter);
my @faa;
my @fbb;
my $foo = 1;

print "1..", 6 * (1 + scalar @converter), "\n";

compile Language::INTERCAL 'converter', $converter;
@faa = @src;
@fbb = (@converter, '');
converter(\&faa, \&foo);
print "not " if $@;
print "ok ", $foo++, "\n";

compile Language::INTERCAL 'converter_o', $converter, 'opt';
@faa = @src;
@fbb = (@converter, '');
converter_o(\&faa, \&foo);
print "not " if $@;
print "ok ", $foo++, "\n";

compile Language::INTERCAL 'converter_q', $converter, 'quantum';
@faa = @src;
@fbb = (@converter, '');
converter_q(\&faa, \&foo);
print "not " if $@;
print "ok ", $foo++, "\n";

compile Language::INTERCAL 'converter_p', $converter, 'post';
@faa = @src;
@fbb = (@converter, '');
converter_p(\&faa, \&foo);
print "not " if $@;
print "ok ", $foo++, "\n";

compile Language::INTERCAL 'converter_qp', $converter, 'quantum', 'post';
@faa = @src;
@fbb = (@converter, '');
converter_qp(\&faa, \&foo);
print "not " if $@;
print "ok ", $foo++, "\n";

compile Language::INTERCAL 'converter_d', $converter, 'dbhook';
@faa = @src;
@fbb = (@converter, '');
_run_db(converter_d(\&faa, \&foo));
print STDERR $@;
print "not " if $@;
print "ok ", $foo++, "\n";

sub foo {
    print "not " if join('', @_) ne (shift @faa) . "\n";
    print "ok ", $foo++, "\n";
}

sub faa {
    shift @fbb;
}

