########################################################################
#
# generate the .c-file
#
########################################################################
proc genDotC {outName} {
  global cbase debug D L Program cligVersion haveMandatory

  set pname [file tail [file rootname $Program]]
  set outBase [file tail [file rootname $outName]]
  set out [open $outName w]

  puts $out "/*****
  command line parser -- generated by $pname (Version: $cligVersion)

  The command line parser `clig':
  (C) 1995 Harald Kirsch (kir@iitb.fhg.de)
*****/

\#include <stdio.h>
\#include <stdlib.h>
\#include <string.h>
\#include <ctype.h>

/* mainly a hack to make things work on SUNOS with gcc */
extern double strtod(const char *, char **);
extern long int strtol(const char *, char **, int);

\#include \"${outBase}.h\"

char *Program;

/*@-null*/
[genDefault]
/*@=null*/

/***** let LCLint run more smoothly */
/*@-predboolothers*/
/*@-boolops*/


/**********************************************************************/"

  flush $out
  foreach file {
    getIntOpt getIntOpts
    getFloatOpt getFloatOpts
    getStringOpt getStringOpts
    checkIntLower checkIntHigher
    checkFloatLower checkFloatHigher
  } {
    exec cat [glob $cbase/$file.c] >@$out
  }

  if { $haveMandatory } {
    exec cat [glob $cbase/missingErr.c] >@$out
  }

  global argvString
  if [info exist argvString] {
    exec cat [glob $cbase/catArgv.c] >@$out
  }
  if { $debug } {
    puts $out [genShowOptionValues]
  }
  puts $out [genUsage]
  puts $out [genParse]
  close $out
}
