# Authors:  Jens Peter Secher (jpsecher@diku.dk)
#           Arne Glenstrup (panic@diku.dk)
#           Henning Makholm (makholm@diku.dk)
# Content:  C-Mix system: manual page extraction script
#
# Copyright  1999. The TOPPS group at DIKU, U of Copenhagen.
# Redistribution and modification are allowed under certain
# terms; see the file COPYING.cmix for details.
$srcdir=shift ;

$cmixII="C-Mix/II" ;

sub process {
	$_ = $_[0] ;
	# ignore comment lines
	s/^%MAN-TEX:\s*// ;
	return if /^\s*%/ ;
	# empty lines become '.lP'
	s/^\s*$/lP\n/ ;
	# remove ignored parts
	s/\\manIgnore{.*}//g ;
	# manage indentation level
	s/^\\begin{[a-z]+}\s*$/lB\n/ ;
	s/^\\end{[a-z]+}\s*/lE\n/ ;
	# translate the product name
	s/\\cmix({})?/$cmixII/g ;
	#---------------------------------------
	# translate bold and italic
	while ( /[]/ ) {
		s/^([^]*)([^]*)/$1\\fB$2\\fP/ and next ;
		s/^([^]*)([^]*)/$1\\fI$2\\fP/ and next ;
		die "bad font selection pattern '$_'" ;
	}
	# translate \emph
	s/\\emph{([^{}]*)}/\\fB$1\\fP/g ;
	# translate \verb+ - NB: only '+' is allowed as delimiter
	s/\\verb\+([^+]*)\+/\\fB$1\\fP/g ;
	# translate $n$
	s/\$([a-z])\$/\\fI$1\\fP/g ;
	# translate \eg and \ie
	s/\\eg/e.g.\\&/g ;
	s/\\ie/i.e.\\&/g ;
	#---------------------------------------
	# translate en dashes
	s/\\-//g; s/---/\\*-/g ; s/--/\\-/g ;
	# translate named and unnamed items
	s/\\item\s*\[([^][]*)\]\s*(\\-\s*)?/lI "$1"\n/g ;
	s/\\item\s*/lI \\-\n/g ;
	# translate tildes
	s/~/\\ /g ;
	# translate escaped characters
	s/\\([%_#\$])/$1/g ;
	# translate quotes
	s/``|''/"/g ;
	# translate example lines
	s/^\s*\\example\s*{(.*)}\s*$/Ex "$1"\n/ ;
	# translate pseudobrackets
	s/<\|/[/g ; s/\|>/]/g ;
	# translate newline-as-space suppressor
	s/%\s*$/\\c\n/ ;
	# remove leading spaces
	s/^\s+// ;
	# escape leading dots; restore interpolated ones
	s/^([.'\\])/\\&$1/ ; s//./g ;
	print $_ ;
}

$header = <<'ENDHEADER' ;
\."-------------------------------------
\." Find the right way to typeset dashes
.if n .ds - " - \" embed space in string
.if t .ds - \\(em
\."---------------------------------------------------
\." These macros helps emulate LaTeX list environments
.nr lR 0  \" requested level
.nr lA 0  \" actual .RS/.RE level
.de lF    \" make actual match requested
.if \\n(lA>\\n(lR \{\
.  RE
.  nr lA -1
.  lF \}
.if \\n(lA<\\n(lR \{\
.  RS
.  nr lA +1
.  lF \}
..
.de lP    \" list-aware paragraph command
.lF
.P
..
.de lB    \" begin list
.nr lR +1
..
.de lE    \" end list
.nr lR -1
.lP
..
.de lI    \" Item
.nr lR -1 \" temporarily lower the requested level
.lF       \" execute the requested level
.TP       \" begin a '-man' itemized paragraph
\\$1
.nr lR +1 \" restore the real requested level
..
.de Ex    \" example line
.lF
.IP
\&\fB\\$1\fR
.P
..
ENDHEADER

while( <> ) {
	s/CMIX/$cmixII/g ;
	if ( /^(.*)\*\*@\*\* (.*)$/ ) {
		print $1 ;
		open infile,"$srcdir/$2" or die "cannot process '$srcdir/$2'" ;
		$copying = 1 ;
		while ( <infile> ) {
			$copying=1, next      if /^%MAN ON/ ;
			$copying=0, next      if /^%MAN OFF/ ;
			(print "$1\n"), next  if /^%MAN%(.*)/ ;
			process $_ if $copying ;
		}
		close infile
	} elsif ( /@@\*@@/ ) {
		print $header ;
	} else {
		print ;
	}
}
