/*	File:	  code.h
 *      Author:	  Henning Makholm (makholm@diku.dk)
 *             	  Sebastian Skalberg (skalberg@diku.dk)
 *      Content:  CMix Cogen library: Code definitions.
 *
 *      Copyright  1999. The TOPPS group at DIKU, U of Copenhagen.
 *      Redistribution and modification are allowed under certain
 *      terms; see the file COPYING.cmix for details.
 */
  
#ifndef __code__
#define __code__

struct Interval ;
struct cmixDecl ;
union cmixExpr ;

/*----------------------------------------------------------------------*
 * Expressions								*
 *----------------------------------------------------------------------*/

enum cmixExprTag { LiftFloat = 0,
                   LiftDouble = 1,
                   LiftLongDouble = 2,
                   Inner, NameRequest, Name, LiftChar, LiftInt };

struct cmixExprCommon {
    enum cmixExprTag tag ;
};
struct cmixExprInner {
    enum cmixExprTag tag ;
    char const *string ;
    union cmixExpr *child[1] ;
    /* struct hack used here */
};
struct cmixExprName {
    enum cmixExprTag tag ;
    unsigned index ;
    unsigned seq ;
    struct cmixDecl *decl ;
};
struct cmixExprLiftInt {
    enum cmixExprTag tag ;
    unsigned long data ;
};
struct cmixExprLiftFloat {
    enum cmixExprTag tag ;
    FLOATLIFTER data ;
    void (*write)(FILE *fp,int,FLOATLIFTER);
};
union cmixExpr {
    struct cmixExprCommon common ;
    struct cmixExprInner inner ;
    struct cmixExprName name ;
    struct cmixExprLiftInt lift_int ;
    struct cmixExprLiftFloat lift_float ;
};

int /* bool */ cmixInnerOK(struct cmixExprInner*);
/* defined in unparse.cc because that is where printInner,
 * which parses the format string similarly, is
 */

/*----------------------------------------------------------------------*
 * Statements								*
 *----------------------------------------------------------------------*/

enum cmixStmtTag { Label, Plain, Goto, If, Return, Abort };

union cmixStmt ;
struct cmixStmtCommon {
    enum cmixStmtTag tag ;
    union cmixStmt *next ;
};
struct cmixStmtLabel {
    enum cmixStmtTag tag ;
    union cmixStmt *next ;
    struct Interval *interval ;
    unsigned refcount ;
    unsigned number ;
    int defined ;
};    
struct cmixStmtPlain {
    enum cmixStmtTag tag ;
    union cmixStmt *next ;
    struct cmixExprInner expr ;
};
struct cmixStmtGoto {
    enum cmixStmtTag tag ;
    union cmixStmt *next ;
    struct cmixStmtLabel *target ;
};
struct cmixStmtIf {
    enum cmixStmtTag tag ;
    union cmixStmt *next ;
    struct cmixStmtLabel *then_target ;
    struct cmixStmtLabel *else_target ;
    struct cmixExprInner *cond ;
};
union cmixStmt {
    struct cmixStmtCommon common ;
    struct cmixStmtLabel label ;
    struct cmixStmtPlain plain ;
    struct cmixStmtGoto jump ;
    struct cmixStmtIf cond ;
};

/*----------------------------------------------------------------------*
 * Declarations								*
 *----------------------------------------------------------------------*/

enum cmixDeclStatus { Sure, Maybe, Done };
struct cmixDecl {
    struct cmixDecl *next ; /* next in declaration order */

    struct cmixDecl *sibling ; /* next declaration for same name */
    enum cmixDeclStatus status ;
    struct cmixDecl *members ;
    struct cmixExprInner decl ;
} ;

/*----------------------------------------------------------------------*
 * Functions								*
 *----------------------------------------------------------------------*/

struct cmixFun {
    struct cmixFun *next ;
    struct cmixFun *prev_cur ;
    struct cmixDecl **prev_lastlocal ;
    
    Code resname ;
    struct cmixDecl *locals ;
    union cmixStmt *stmts, **last_stmt ;

    int sharable ;
    int shared ;
    const char *memoname ;
    cmixSavedState state, end_state ;
    struct cmixExprInner heading ;
};

/*----------------------------------------------------------------------*
 * Globals								*
 *----------------------------------------------------------------------*/

extern struct cmixDecl *cmixDecls[cmixDECLCLASSES] ;
extern struct cmixFun *cmixFuns ;

/*---------------------------------------------------------------------------*
 * Restructuring
 *---------------------------------------------------------------------------*/

extern int cmixRestruct;

struct Interval;
struct Loop;

typedef struct iList {
  struct Interval *interval;
  struct iList *next;
} iList;

typedef enum iType { basic, ilist } iType;

typedef union iMember {
  struct basic {
    struct cmixStmtLabel *label;
    union cmixStmt *control;
    struct Interval *ifFollow;
    struct Interval *immDom;
    struct Loop *loop;
    int printed;
  } basic;
  struct iList *ilist;
} iMember;

typedef struct Interval {
  unsigned number;
  struct Interval *parent;
  int loopCheckDone;
  unsigned path ;
  iType type;
  iMember member;
  iList *back_refs;
  iList *forw_refs;
} Interval;

enum loopType { wile, dowile, endless };

typedef struct Loop {
  enum loopType type;
  Interval *header;
  Interval *latch;
  Interval *follow;
} Loop;

typedef struct Restruct {
  Interval **order;
  unsigned count;
} Restruct;

Restruct *cmixRestructStmts(union cmixStmt *);

#endif /* __code__ */
