(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                config.mli                                *)
(****************************************************************************)


val bindir : string     (* where the binaries are installed *)
val coqlib : string     (* where the std library is installed *)

val coqtop : string     (* where are the sources *)

(*For Dynlink*)
val camllib:string;;

(* OBSOLETE ? val camlbin : string    (* where are the binaries of Caml *) *)
val camlp4lib : string  (* where is the library of Camlp4 *)

val arch : string       (* architecture (result of `arch`) *)
val osdeplibs : string  (* OS dependant link options for ocamlc *)

val defined : string list  (* options for lib/util/ocamlpp *)

val version : string    (* version number of Coq *)
val versionsi : string  (* version number of Coq_SearchIsos *)
val date : string       (* release date *)
val compile_date : string (* compile date *)

val theories_dirs : string list
val tactics_dirs  : string list
val src_dirs      : string list

(* $Id: coq_config.mli,v 1.8 1999/06/29 07:46:56 loiseleu Exp $ *)
