(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                               environ.mli                                *)
(****************************************************************************)

open Names
open Pp
open More_util
open Term
open Constrtypes
open Libobject
open Impuniv

(* Constants and Inductives *)

val const_of_path : section_path -> const_entry
val const_option_of_path : section_path -> const_entry option
val mind_of_path : section_path -> section_path * mutual_inductive_body
val mind_option_of_path : section_path -> (section_path * mutual_inductive_body) option

val search_synconst : path_kind -> identifier -> constr

type variable_object = identifier * 
                       (type_judgement * (type_judgement*implicits_typ) option) * 
                       strength * implicits_typ * bool * universes

type constant_object = constdecl_body * strength * universes
val print_constant_object : int -> constant_object -> std_ppcmds

type syntaxconstant_object = (path_kind,constr) Listmap.t

val specification_variable : variable_object -> variable_object
val inVariable : variable_object -> obj
val outVariable : obj -> variable_object

val specification_constant : constant_object -> constant_object
val inConstant : constant_object -> obj
val outConstant : obj -> constant_object

val inSyntaxConstant : syntaxconstant_object -> obj
val outSyntaxConstant : obj -> syntaxconstant_object

type mutual_inductive_object = mutual_inddecl_body * universes
val specification_minductive :
  mutual_inductive_object -> mutual_inductive_object
val inMutualInductive : mutual_inductive_object -> obj
val outMutualInductive : obj -> mutual_inductive_object


val global_operator : section_path -> identifier -> sorts oper * type_judgement signature
val global_operator1 : section_path -> identifier ->
  (sorts oper * type_judgement signature) * int list
val id_of_global : sorts oper -> identifier

val id_of_name_using_hdchar : constr -> name -> identifier
val named_hd : constr -> name -> name
val prod_name : name * constr * constr -> constr
val prod_create : constr * constr -> constr
val lambda_name : name * constr * constr -> constr
val lambda_create : constr * constr -> constr
val it_prod_name : constr -> (name * constr) list -> constr
val it_lambda_name : constr -> (name * constr) list -> constr

(* $Id: environ.mli,v 1.16 1999/10/29 23:18:55 barras Exp $ *)

