(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                vartab.ml                                 *)
(****************************************************************************)

open Names;;
open Term;;
open Constrtypes;;

(* Sections and Sticky Stack Summary *)
let aUTO_ABS_VARS = ref ([] : identifier list);;

let auto_save_variables () = !aUTO_ABS_VARS;;

let vARIABLES = 
  ref (nil_sign : (type_judgement * ((type_judgement*implicits_typ) option  * strength * implicits_typ)) 
                  signature);;

(* Amok: liste des variables avec leur strength *)

let stre_of_var id = 
  let (_,(_,(_,stre,_))) = lookup_glob id (gLOB (!vARIABLES)) in stre
;;

let implicits_of_var k id = 
  match k with 
    CCI -> let (_,(_,(_,_,l))) = lookup_glob id (gLOB (!vARIABLES)) in
             Constrtypes.list_of_implicits l
  | FW -> (match lookup_glob id (gLOB (!vARIABLES)) with
	       (_,(_,((Some(_,l)),_,_))) -> 
		 Constrtypes.list_of_implicits l
	     | _ -> Std.anomaly "implicits_of_var : lookup_glob failed")
  | _ -> []
;;

let initial_sign () = map_sign_typ fst !vARIABLES;;
let initial_fsign () =
  sign_it 
    (fun id p_1 sign -> match p_1 with 
         (_,(Some (fty,_),_,_)) -> add_sign (id,fty) sign
       | _ -> sign)
    !vARIABLES nil_sign
;;
let initial_assumptions () = (initial_sign(),initial_fsign());;

(* modif Amok: prise en compte des strength *)

let push id sticky (ty,fty) str impl=
  let (idl,tyl) = !vARIABLES in
  vARIABLES := (id::idl,(ty,(fty,str,impl))::tyl) ;
  if sticky then aUTO_ABS_VARS := id::!aUTO_ABS_VARS
;;

let init () = 
  vARIABLES     := nil_sign;
  aUTO_ABS_VARS := []
;;

type frozen_t = (type_judgement * ((type_judgement*implicits_typ) option * strength * implicits_typ)) signature
               * identifier list 
;;

let freeze  () = (!vARIABLES,!aUTO_ABS_VARS);;
let unfreeze(v,a) = (vARIABLES := v;
                       aUTO_ABS_VARS := a);;

Summary.declare_summary "var"
  {Summary.freeze_function = freeze;
   Summary.unfreeze_function = unfreeze;
   Summary.init_function = init}
;;

let rollback f () =
    let fs = freeze()
    in try f ()
       with e -> (unfreeze fs; raise e)
;;

(* $Id: vartab.ml,v 1.14 1999/10/29 23:18:59 barras Exp $ *)
