
open Pp;;
open Vectops;;
open Std;;
open List;;
open More_util;;
open CoqAst;;
open Names;;
open Libobject;;
open Library;;
open Classops;;
open Term;;
open Mach;;

open Termenv;;
open Himsg;;
open Generic;;
open Vartab;;
open Environ;;
open Machops;;
open Dischcore;;
open Generic;;
open Declare;;
open Constrtypes;;

(* manipulations concernant les strength *)

(* gt dans le sens de "longueur du sp" (donc le moins persistant) *)

(* strength * strength -> bool *)

let stre_gt = function (NeverDischarge,NeverDischarge) -> false
                      | (NeverDischarge,x) -> false
                      | (x,NeverDischarge) -> true
                      | (DischargeAt sp1,DischargeAt sp2) -> sp_gt (sp1,sp2) 
;;

let stre_max (stre1,stre2) = if stre_gt (stre1,stre2) then stre1
                             else stre2
;;

let stre_max4 stre1 stre2 stre3 stre4 = stre_max ((stre_max (stre1,stre2)),(stre_max (stre3,stre4)));;

let id_of_varid = function (VAR id) -> id | _ -> anomaly "class__id_of_varid";;

let stre_of_VAR c = stre_of_var (destVar c);;

(* lf liste des variable dont depend la coercion f
   lc liste des variable dont depend la classe source *)

let rec stre_unif_cond =
function ([],[]) -> NeverDischarge
       | (v::l,[]) -> stre_of_VAR v
       | ([],v::l) -> stre_of_VAR v
       | (v1::l1,v2::l2) -> if v1=v2 
                           then stre_unif_cond (l1,l2)
                           else let stre1 = (stre_of_VAR v1) and
                                    stre2 = (stre_of_VAR v2) in
                                stre_max (stre1,stre2)
;;

let stre_of_coe = 
  function NAM_SP sp ->
                    (match Lib.leaf_object_tag (objsp_of sp) with
                     "CONSTANT" ->
                       let (_,stre,_) = outConstant(Lib.map_leaf (objsp_of sp)) in stre
                    | _ -> NeverDischarge)
          | NAM_Var id -> stre_of_var id
          | _ -> NeverDischarge
;;

(* try_add_class : Names.identifier ->
  Term.constr -> (cl_typ * int) option -> bool -> int * Libobject.strength *)

let try_add_class id v clpopt streopt check_exist = 
  let (sigma,sign) = initial_sigma_sign() in
  let t = type_of sigma sign v in
  let p1 =
    try arity_sort t 
    with Not_found -> errorlabstrm "try_add_class" 
        [< 'sTR"Type of "; 'sTR(string_of_id id);
           'sTR" does not end with a sort" >] in
  let cl,p =
    match clpopt with
        None -> let (cl,_)=constructor_at_head v in (cl,p1)
      | Some (cl,p2) -> (fully_applied id p2 p1;cl,p1) in
  let _ = if check_exist then
    (try (class_info cl;
          errorlabstrm "try_add_new_class" 
            [< 'sTR(string_of_id id) ; 'sTR" is already a class" >])
     with Not_found -> ()) in
  let stre' = stre_of_cl cl in 
  let stre = (match streopt with
                  (Some stre) -> stre_max (stre,stre')
                | None -> stre') in
    add_new_class (cl,(string_of_id id),stre,p);
    stre
;;

(* try_add_new_class : Names.identifier -> unit *)

let try_add_new_class id stre =
let v = global (gLOB(initial_sign())) id in
try_add_class id v None (Some stre) true;() 
;;

(* check_class : Names.identifier ->
  Term.constr -> cl_typ -> int -> int * Libobject.strength *)

let check_class id v cl p =
 try let _,clinfo = class_info cl in
     if p = clinfo.cL_PARAM
     then clinfo.cL_STRE
     else errorlabstrm "fully_applied" 
          [< 'sTR"Wrong number of parameters for ";'sTR(string_of_id id) >]
 with Not_found -> try_add_class id v (Some (cl,p)) None false
;;

(* decomposition de constr vers coe_typ *)

let coe_constructor_at_head t = 
let rec aux t' = match t' with
    (DOPN(Const sp,l)) -> (Array.to_list l),NAM_SP sp
  | (DOPN(MutInd (sp,_),l)) -> (Array.to_list l),NAM_SP sp
  | (VAR(id)) -> [],NAM_Var id
  | (DOP2(Cast,c,_)) -> aux c
  | (DOPN(MutConstruct ((sp,i),j) ,l)) -> (Array.to_list l),NAM_Construct (sp,i,j)
  | (DOPN(AppL,cl)) -> aux (hd_vect cl) 
  |  _ -> raise Not_found
in aux (collapse_appl t)
;;

let constructor_at_head1 t = 
let rec aux t' = match t' with
    (DOPN(Const sp,l)) -> t',[],(Array.to_list l),CL_SP sp,0
  | (DOPN(MutInd (sp,i),l)) -> t',[],(Array.to_list l),CL_IND (sp,i),0
  | (VAR(id)) -> t',[],[],CL_Var id,0
  | (DOP2(Cast,c,_)) -> aux c
  | (DOPN(AppL,cl)) -> let t',_,l,c,_ = aux (hd_vect cl) 
                        in t',(Array.to_list (tl_vect cl)),l,c,Array.length(cl)-1
  | DOP2(Prod,_,DLAM(_,c)) -> t',[],[],CL_FUN,0
  | DOP0(Sort(_)) -> t',[],[],CL_SORT,0
  |  _ -> raise Not_found
in aux (collapse_appl t)
;;

(* condition d'heritage uniforme *)

let uniform_cond nargs lt = 
let rec aux = function
   (0,[]) -> true
 | (n,t::l) -> (strip_outer_cast t = Rel n) & (aux ((n-1),l))
 | _ -> false
in aux (nargs,lt)
;;

let id_of_cl  = function CL_FUN -> (id_of_string "FUNCLASS")
                        | CL_SORT -> (id_of_string "SORTCLASS") 
                        | CL_SP sp -> (basename sp)
                        | CL_IND (sp,i) -> let (_,mib) = mind_of_path (ccisp_of sp) in
                                            mib.mINDPACKETS.(i).mINDTYPENAME
                        | CL_Var id -> id 
;;

let string_of_cl  = function CL_FUN -> "FUNCLASS"
                        | CL_SORT -> "SORTCLASS" 
                        | CL_SP sp -> string_of_id (basename sp)
                        | CL_IND (sp,i) -> let (_,mib) = mind_of_path (ccisp_of sp) in
                                            string_of_id mib.mINDPACKETS.(i).mINDTYPENAME
                        | CL_Var id -> string_of_id id 
;;



(* 
lp est la liste (inverse'e) des arguments de la coercion
ids est le nom de la classe source
sps_opt est le sp de la classe source dans le cas des structures
retourne:
la classe souce
nbre d'arguments de la classe
le constr de la class
l'indice de la classe source dans la liste lp
la liste des variables dont depend la classe source
*)

let get_source lp source =
let aux test =
let rec aux1 n = function
   [] -> raise Not_found
 | t1::lt -> try (let v1,lv1,l,cl1,p1 = constructor_at_head1 t1 in
                  if test cl1 
                  then cl1,p1,v1,lv1,n,l
                  else aux1 (n+1) lt)
             with _ -> aux1 (n + 1) lt
in aux1 1 lp
in match source with
    None -> let (v1,lv1,l,cl1,p1) as x = (match lp with [] -> raise Not_found
                         | t1::_ -> try constructor_at_head1 t1
                                    with _ -> raise Not_found)
            in (id_of_cl cl1),(cl1,p1,v1,lv1,1,l)
   | Some(Left ids) -> ids,aux (function CL_Var id  ->  ids=id
                                 | CL_SP sp -> (basename sp) = ids
                                 | CL_IND (sp,i) -> let (_,mib) = mind_of_path (ccisp_of sp) in
                                                     mib.mINDPACKETS.(i).mINDTYPENAME = ids
                                 | CL_SORT -> "SORTCLASS" = (string_of_id ids)
                                 | CL_FUN  -> "FUNCLASS" = (string_of_id ids))
   | Some (Right sp) -> basename sp,aux (function CL_SP sp1 -> sp=sp1
                                     | CL_IND (sp1,i) -> sp=sp1
                                     | _ -> false)
              
;;

let get_target t ind =
 if (ind > 1) 
 then CL_FUN,0,t
 else let v2,_,_,cl2,p2 = constructor_at_head1 t in
       cl2,p2,v2
;;

let prods_of t = 
let rec aux acc = function
   DOP2(Prod,c1,DLAM(_,c2)) -> aux (c1::acc) c2
  | (DOP2(Cast,c,_)) -> aux acc c
  | t -> t::acc
in aux [] t
;;

(* coercion identite' *)

let lams_of t = 
let rec aux acc = function
   DOP2(Lambda,c1,DLAM(x,c2)) -> aux ((x,c1)::acc) c2
  | (DOP2(Cast,c,_)) -> aux acc c
  | t -> acc,t
in aux [] t
;;

let build_id_coercion idf_opt ids =
let (sigma,(sign,fsign)) = initial_sigma_assumptions() in
let vs = global (gLOB(initial_sign())) ids in 
let c = match (strip_outer_cast vs) with
 (DOPN(Const sp,l) as c') -> (try const_value sigma c'
                             with _ -> errorlabstrm "build_id_coercion"
                              [< 'sTR(string_of_id ids); 'sTR" must be a transparent constant" >])
 | _ -> errorlabstrm "build_id_coercion"
                              [< 'sTR(string_of_id ids); 'sTR" must be a transparent constant" >] in
let lams,t = lams_of c in
let lams = rev lams in
let llams = length(lams) in
let val_f = fold_right (fun (x,t) u -> DOP2(Lambda,t,DLAM(x,u)))
             lams (DOP2(Lambda,(applistc vs (rel_list 0 llams)),DLAM(Name (id_of_string "x"),Rel 1))) in
let typ_f = fold_right (fun (x,t) c -> DOP2(Prod,t,DLAM(x,c)))
             lams (DOP2(Prod,(applistc vs (rel_list 0 llams)),DLAM(Anonymous,lift 1 t))) in 
let constr_f = DOP2(Cast,val_f,typ_f) in
(* juste pour verification *)
let _ = try type_of sigma (initial_sign()) constr_f
        with _ ->  error "cannot be defined as coercion - may be a bad number of arguments" in
let idf = (match idf_opt with Some(idf) -> idf
                           | None -> id_of_string ("Id_"^(string_of_id ids)^"_"^
                                       (string_of_cl (fst (constructor_at_head t)))))
in machine_constant (initial_assumptions()) ((idf,false,NeverDischarge),constr_f); idf
;;

let coercion_syntax_entry id n =
  let args = (String.concat " " (tabulate_list (fun _ -> "$_") n)) ^ " $c" in
  let str = "level 10: " ^ (string_of_id id) ^
            " [ <<(" ^ (string_of_id id) ^ " " ^ args ^ ")>> ]" ^
            " -> [ (APPLIST $c):E ]"
  in
    try
      let se = Pcoq.parse_string Pcoq.Prim.syntax_entry_eoi str in
        Metasyntax.add_syntax_obj "constr" [se]
    with Stdpp.Exc_located _ -> anomaly ("ill-formed syntax entry: "^str)
;;


let fun_coercion_syntax_entry id n =
  let args =
    if n<0 then anomaly "fun_coercion_syntax_entry"
    else
      String.concat " " (tabulate_list (fun _ -> "$_") n) ^ " $c ($LIST $l)" in
  let str = "level 10: " ^ ((string_of_id id)^"1") ^
            " [ (APPLIST " ^ (string_of_id id) ^ " " ^ args ^ ") ] "  ^
      	    "-> [ (APPLIST $c ($LIST $l)):E ]"
  in
    try
      let se = Pcoq.parse_string Pcoq.Prim.syntax_entry_eoi str in
        Metasyntax.add_syntax_obj "constr" [se]
    with Stdpp.Exc_located _ -> anomaly ("ill-formed syntax entry: "^str)
;;


let coercion_syntax idf ps clt =
match clt with CL_FUN -> 
     (fun_coercion_syntax_entry idf ps;
      coercion_syntax_entry idf ps)
   | _ -> coercion_syntax_entry idf ps
;;

let add_new_coercion_in_graph1 (coef,v,stre,isid,cls,clt) idf ps =
add_anonymous_object (inCoercion ((coef,{cOE_VALUE=v;cOE_STRE=stre;cOE_ISID=isid;cOE_PARAM=ps}),cls,clt)) ;
coercion_syntax idf ps clt
;;

(* 
nom de la fonction coercion
strength de f
nom de la classe source (optionnel)
sp de la classe source (dans le cas des structures)
nom de la classe target (optionnel)
booleen "coercion identite'?"

lorque source est None alors target est None aussi.
*)


(* pas tre`s optimise' pour les cas particuliers...
   trop bricole' au fil du temps, a` revoir un jour *)

let try_add_new_coercion idf_opt stre source target isid = 
 let (sigma,sign) = initial_sigma_sign () in
 let idf = if isid 
           then (match source with 
                  Some(Left ids) -> build_id_coercion idf_opt ids
                | Some (Right sp) -> build_id_coercion idf_opt (basename sp)
                | None -> match idf_opt with None -> anomaly "try_add_coercion--coercion name?"
                                           | Some idf -> idf)
           else (match idf_opt with None -> anomaly "try_add_coercion--coercion name?"
                                  | Some idf -> idf) in
 let v = global (gLOB(initial_sign())) idf in
 let f_vardep,coef = coe_constructor_at_head v in
 let _ = try (coercion_info coef;
              errorlabstrm "try_add_coercion" 
                  [< 'sTR(string_of_id idf) ; 'sTR" is already a coercion" >])
         with Not_found -> () in
 let t = type_of sigma (initial_sign()) v in
 let lp = prods_of t in
 let llp = length lp in
 let _ = if llp <= 1 
         then errorlabstrm "try_add_coercion"         
              [< 'sTR"Does not correspond to a coercion" >] in

 let ids,(cls,ps,vs,lvs,ind,s_vardep) = try get_source (tl lp) source
        with Not_found -> errorlabstrm "try_add_coercion" 
                 [<'sTR"We do not find the source class " >] in

 let _ = if (cls = CL_FUN)
         then errorlabstrm "try_add_coercion" 
              [< 'sTR"FUNCLASS cannot be a source class" >] in
 let _ = if (cls = CL_SORT)
         then errorlabstrm "try_add_coercion" 
              [< 'sTR"SORTCLASS cannot be a source class" >] in

 let _ = if not (uniform_cond (llp-1-ind) lvs)
         then errorlabstrm "try_add_coercion" 
              [<'sTR(string_of_id idf);
                'sTR" does not respect the inheritance uniform condition" >] in
 let clt,pt,vt = try get_target (hd lp) ind 
              with Not_found -> errorlabstrm "try_add_coercion" 
                   [<'sTR"We cannot find the target class" >] in
 let idt = (match target with Some idt -> 
               if idt = id_of_cl clt
               then idt
               else errorlabstrm "try_add_coercion" 
                   [<'sTR"The target class does not correspond to "; 'sTR(string_of_id idt) >]
             | None -> (id_of_cl clt)) in
 let stres = check_class ids vs cls ps in
 let stret = check_class idt vt clt pt in
 let stref = stre_of_coe coef in
 let streunif = stre_unif_cond (s_vardep,f_vardep) in
 let stre' = stre_max4 stres stret stref streunif in
(* if (stre=NeverDischarge) & (stre'<>NeverDischarge)
 then errorlabstrm "try_add_coercion" 
      [<'sTR(string_of_id idf); 'sTR" must be declared as a local coercion (its strength is ";
        'sTR(string_of_strength stre');'sTR")" >] *)
 let stre = stre_max (stre,stre') in
 add_new_coercion_in_graph1 (coef,v,stre,isid,cls,clt) idf ps
;;
 
 
(* fonctions pour le discharge: plutot sale *)

let defined_in_sec sp sec_sp =
let ((p1,id1,k1)) = repr_path sp in
let ((p2,id2,k2)) = repr_path sec_sp in
(*pPNL [< prlist_with_sep pr_spc pr_str p1; 'fNL; 
        prlist_with_sep pr_spc pr_str p2@[(string_of_id id2)]) >]; *)
        p1 = (string_of_id id2)::p2
;;


let process_class sec_sp ((cl,{cL_STR=s;cL_STRE=stre;cL_PARAM=p}) as x ) =
  let (sigma,sign) = initial_sigma_sign() in
    match cl with 
        CL_Var id -> x
      | CL_SP sp -> 
          if defined_in_sec sp sec_sp 
          then let ((_,spid,spk)) = repr_path sp in
               let newsp = Lib.make_path CCI spid in 
               let v = global_reference (gLOB sign) newsp spid in
               let t = type_of sigma sign v in
               let p = arity_sort t in
                 (CL_SP newsp,{cL_STR=s;cL_STRE=stre;cL_PARAM=p})
          else x
      | CL_IND (sp,i) ->
          if defined_in_sec sp sec_sp 
          then let ((_,spid,spk)) = repr_path sp in
               let newsp = Lib.make_path CCI spid in 
               let v = global_reference (gLOB sign) newsp spid in
               let t = type_of sigma sign v in
               let p = arity_sort t in
                 (CL_IND (newsp,i),{cL_STR=s;cL_STRE=stre;cL_PARAM=p})
          else x
      | _ -> anomaly "process_class" 
;;

let process_cl sec_sp cl =
match cl with CL_Var id -> CL_Var id 
            | CL_SP sp -> if defined_in_sec sp sec_sp 
                          then let ((_,spid,spk)) = repr_path sp in
                               let newsp = Lib.make_path CCI spid in 
                               CL_SP newsp
                          else cl
            | CL_IND (sp,i) -> if defined_in_sec sp sec_sp 
                          then let ((_,spid,spk)) = repr_path sp in
                               let newsp = Lib.make_path CCI spid in 
                               CL_IND (newsp,i)
                          else cl
            | _ -> cl
;;

let process_coercion sec_sp ( ((coe,{cOE_VALUE=v;cOE_STRE=stre;cOE_ISID=b;
                                 cOE_PARAM=p}),s,t) as x) =
let s1= process_cl sec_sp s in
let t1 = process_cl sec_sp t in
let p = (snd (class_info s1)).cL_PARAM in
match coe with 
  NAM_Var id -> ((coe,{cOE_VALUE=v;cOE_STRE=stre;cOE_ISID=b; cOE_PARAM=p}),
                    s1,t1),id,p
| NAM_SP sp -> 
  if defined_in_sec sp sec_sp 
  then let ((_,spid,spk)) = repr_path sp in
       let newsp = Lib.make_path CCI spid in
       let v = global_reference (gLOB(initial_sign())) newsp spid in
          ((NAM_SP newsp,{cOE_VALUE=v;cOE_STRE=stre;cOE_ISID=b; cOE_PARAM=p}),
             s1,t1),spid,p
  else ((coe,{cOE_VALUE=v;cOE_STRE=stre;cOE_ISID=b; cOE_PARAM=p}),
               s1,t1),basename sp,p
| NAM_Construct (sp,i,j) -> 
      if defined_in_sec sp sec_sp 
      then 
         let ((_,spid,spk)) = repr_path sp in
         let newsp = Lib.make_path CCI spid in
         let id = id_of_global (MutConstruct((newsp,i),j)) in
         let v = global_reference (gLOB(initial_sign())) newsp id in
            (((NAM_Construct (newsp,i,j)),
               {cOE_VALUE=v;cOE_STRE=stre;cOE_ISID=b; cOE_PARAM=p}),
                    s1,t1),id,p
     else ((coe,{cOE_VALUE=v;cOE_STRE=stre;cOE_ISID=b; cOE_PARAM=p}),
               s1,t1),id_of_global (MutConstruct((sp,i),j)),p
;;

(* Id: class.ml4,v 1.2 1997/06/17 17:44:10 dderaugl Exp $ *)
