(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                  avm.ml                                  *)
(****************************************************************************)

open Std;;

type ('a,'b) t = ('a,'b) Coq_map.t;;
type ('a,'b) frozen_t = ('a,'b) Coq_map.frozen_t;;

let create ord = Coq_map.empty ord;;

let toList m =
let r = ref []
in (Coq_map.iter (fun k v -> r := (k,v)::!r) m;
    !r)
;;

let dom m = List.map fst (toList m);;
let rng m = List.map snd (toList m);;

let map m k = Coq_map.find k m;;

let in_dom m k =
    try (map m k;true)
    with Not_found -> false
;;

let rmv m k = Coq_map.remove k m;;

let add m (k,v) =
    if in_dom m k then raise (Failure "Avm.add")
    else Coq_map.add k v m
;;

let remap m k v = (add (rmv m k) (k,v));;

let app f m = Coq_map.iter (fun k v -> (f(k,v))) m;;

let ofList ord l = List.fold_left add (create ord) l;;

let inv l b = List.map fst (filter (fun (a',b') -> b' = b) (toList l));;

let freeze m = Coq_map.read_tree m;;
let unfreeze fm m = Coq_map.set_tree fm m;;

let clone_empty m = Coq_map.clone_empty m;;

(* $Id: avm.ml,v 1.6 1999/06/29 07:47:14 loiseleu Exp $ *)
