(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                intavm.mli                                *)
(****************************************************************************)

type 'b t;;

val create : unit -> 'b t;;
val map : 'b t -> int -> 'b;;
val dom : 'b t -> int list;;
val rng : 'b t -> 'b list;;
val in_dom : 'b t -> int -> bool;;
val add : 'b t -> int * 'b -> 'b t;;
val rmv : 'b t -> int -> 'b t;;
val remap : 'b t -> int -> 'b -> 'b t;;
val app : ((int * 'c) -> unit) -> 'c t -> unit;;
val toList : 'b t -> (int * 'b) list;;
val ofList : (int * 'b) list -> 'b t;;
val inv : 'b t -> 'b -> int list;;

(* $Id: intavm.mli,v 1.6 1999/06/29 07:47:17 loiseleu Exp $ *)
