(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                intavs.ml                                 *)
(****************************************************************************)

type t = Intset.t;;

let add s e = Intset.add e s;;
let rmv s e = Intset.remove e s;;
let memb s e = Intset.mem e s;;
let intersect = Intset.inter;;
let union = Intset.union;;
let diff = Intset.diff;;
let symdiff l1 l2 = diff(union l1 l2) (intersect l1 l2);;
let subset l1 l2 = List.for_all (memb l2) (Intset.elements l1);;
let equal = Intset.equal;;
let mt = Intset.empty;;

exception Caught;;
let exists p s =
    try (Intset.iter (fun e -> if p e then raise Caught else ()) s;
         false)
    with Caught -> true
;;

let toList = Intset.elements;;

let ofList l = List.fold_left add mt l;;
let is_empty = Intset.is_empty;;

(* $Id: intavs.ml,v 1.4 1999/06/29 07:47:17 loiseleu Exp $ *)
