(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                 mhmfs.ml                                 *)
(****************************************************************************)
open Std;;

type ('a,'b) t = ('a,'b list) Mhm.t;;
type ('a,'b) frozen_t = ('a,'b list) Mhm.frozen_t;;

let create n = Mhm.create n;;
let empty m = Mhm.empty m;;
let map m k =
  try Mhm.map m k
  with Not_found -> []
;;
let dom m = Mhm.dom m;;
let in_dom m k = Mhm.in_dom m k;;
let ind_dom m k = Mhm.in_dom m k;;
let add m (k,v) =
    try Mhm.remap m k (add_set v (Mhm.map m k))
    with Not_found -> Mhm.add m (k,[v])
;;

let rmv m (k,v) =
    Mhm.remap m k (rmv_set v (Mhm.map m k))
;;

let app f m = Mhm.app f m;;
let toList m = Mhm.toList m;;
let freeze m = Mhm.freeze m;;
let unfreeze fm m = Mhm.unfreeze fm m;;

(* $Id: mhmfs.ml,v 1.7 1999/06/29 07:47:18 loiseleu Exp $ *)
