(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                logic.mli                                 *)
(****************************************************************************)

open Initial;;
open Names;;
open Term;;
open Reduction;;
open Termenv;;
open Mach;;
open Proof_trees;;
open Pp;;

(* This should be set true to get the refiner makes extra type checkings *)
(* By default, this is set to false and tactics are supposed to call the *)
(* refiner with correct arguments. If a tactic actually behaves badly    *) 
(* it will be detected only at the very end of the proof                 *)
(*                                                                       *)
(* tac_debug is set to true in Inversion and Program which behaves badly *)
(* tac_debug_conv is used in conversion tactics that seems to be safely  *)
(* guarded                        *)

val tac_debug_conv : bool ref;;
val val_debug : unit -> bool;;
val set_debug : bool -> unit;;

val pr_prim_rule   : prim_rule -> std_ppcmds;;
val prim_refiner   : prim_rule -> 'a Evd.evar_map -> goal -> goal list;;
val prim_extractor : ((type_judgement, constr) env -> proof_tree -> constr) -> 
                        (type_judgement, constr) env -> proof_tree -> constr;;
val extract_constr : constr assumptions -> constr -> constr;;

(* $Id: logic.mli,v 1.11 1999/11/30 19:25:44 mohring Exp $ *)
