(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                               btermdn.mli                                *)
(****************************************************************************)
open Generic;;
open Term;;

type 'a t;;

val create : unit -> 'a t;;

val add : 'a t -> (constr * 'a) -> 'a t;;
val rmv : 'a t -> (constr * 'a) -> 'a t;;

val lookup : 'a t -> constr -> (constr * 'a) list;;
val app : ((constr * 'a) -> unit) -> 'a t -> unit;;

val dnet_depth : int ref;;

(* $Id: btermdn.mli,v 1.7 1999/06/29 07:47:40 loiseleu Exp $ *)
