(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                  evd.ml                                  *)
(****************************************************************************)

open Std;;
open Initial;;
open Names;;
open Term;;

(* The type of mappings for existential variables *)

type evar_body =
    EVAR_EMPTY | EVAR_DEFINED of constr

and 'a evar_info =
    {concl : constr;            (* the type of the evar ...          *)
     hyps  : type_judgement signature;  (* ... under a certain signature     *)
     body  : evar_body;         (* its definition                    *) 
     info  : 'a option          (* any other necessary information   *)
     }         
;;

type 'a evar_map = (section_path, 'a evar_info) Avm.t;;

let mt_evd () = Avm.create sp_ord;;

let toList (evc:'a evar_map)   = Avm.toList evc;;
let dom    (evc:'a evar_map)   = Avm.dom    evc;;
let map    (evc:'a evar_map) k = Avm.map    evc k;;
let rmv    (evc:'a evar_map) k = Avm.rmv    evc k;;
let remap  (evc:'a evar_map) k = Avm.remap  evc k;;
let in_dom (evc:'a evar_map) k = Avm.in_dom evc k;;


let add_with_info evd sp newinfo = 
 Avm.add evd (sp,newinfo)
;;


let add_noinfo evd sp sign typ = 
  let newinfo = 
    {concl = typ;
     hyps  = sign;
     body  = EVAR_EMPTY;
     info  = None}
  in Avm.add evd (sp,newinfo)
;;

let define evd sp body = 
 let oldinfo = map evd sp in
 let newinfo = 
   {concl = oldinfo.concl;
    hyps  = oldinfo.hyps;
    body  = EVAR_DEFINED body;
    info  = oldinfo.info} in
 match oldinfo.body with
     EVAR_EMPTY -> Avm.remap evd sp newinfo
   | _ -> anomaly "cannot define an isevar twice"
;;

(* The list of non-instantiated existential declarations *)

let non_instantiated sigma = 
    let listsp = toList sigma in
    List.fold_left 
        (fun l ((sp,evd) as d) -> if evd.body = EVAR_EMPTY then (d::l) else l)
        [] listsp;;

let is_evar sigma sp = in_dom sigma sp;;


(* $Id: evd.ml,v 1.7 1999/08/06 20:49:13 herbelin Exp $ *)
