(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                              extraction.mli                              *)
(****************************************************************************)

open Names;;
open Generic;;
open Term;;
open Evd;;

val extract_val : information -> constr;;
val extract_typ : information -> constr;;
val extract_kind : information -> constr;;

val inf_var : environment -> contents -> identifier -> information;;
val inf_sort : sorts -> information;;
val inf_apply : information -> information -> information;;

val inf_gen_rel : name -> information -> information -> information;;
(*
val inf_abs_var : identifier -> constr -> information -> information * modification_action;;
*)
val inf_abs_rel : name -> information -> information -> information;;
val inf_abs_rel_count : name -> information -> information -> information*modification_action;;
val inf_rel : environment -> contents -> int -> information;;
val extract : information -> judgement;;
val inf_mutcase : 'a assumptions -> 'c evar_map -> judgement -> case_info -> information -> information array -> information;;
val inf_fix : 'c evar_map -> int -> constr -> name list -> information array -> (information * int) array -> information;;
val inf_cofix : 'c evar_map -> int -> constr -> name list -> information array -> information array -> information;;
val informative_reference : constr -> bool;;
val is_implicit : constr -> bool;;


val is_extraction_expanded : unit -> bool;;
val make_extraction_expanded : bool -> unit;;

(* $Id: extraction.mli,v 1.8 1999/08/06 20:49:14 herbelin Exp $ *)
