(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                               machops.mli                                *)
(****************************************************************************)

open Names
open Vectops
open Impuniv
open Extraction
open Generic
open Term
open Reduction
open Typing
open Pp
open Evd

val cast_fully : bool ref
val j_val : judgement -> constr
val j_val_cast : judgement -> constr
val j_val_only : judgement -> constr

val assumption_of_judgement :
  'b evar_map -> environment -> judgement -> type_judgement
val type_judgement : 'b evar_map -> environment -> judgement -> type_judgement

val fcn_proposition : contents -> judgement
val fcn_type_with_universe : universe -> judgement
val gen_rel : 'b evar_map -> path_kind 
-> environment -> name -> type_judgement -> judgement -> judgement
val abs_rel : 'b evar_map -> name -> type_judgement -> judgement -> judgement
val abs_var : identifier -> type_judgement 
  -> constr * type_judgement -> constr * type_judgement
val abs_var_type: identifier -> type_judgement -> type_judgement -> type_judgement
val relative : 'b evar_map -> int -> environment -> judgement
val apply_rel_list :
  'b evar_map -> environment -> bool -> judgement list -> judgement ->
    judgement
val cast_rel :
  'b evar_map -> environment -> judgement -> judgement -> judgement
val type_of_constant : 'b evar_map -> environment -> constr -> constr
val type_of_const : 'b evar_map -> environment -> constr -> constr
val type_of_const2 : 'b evar_map -> environment -> constr -> constr
val inf_of_const : 'c evar_map -> 'a * environment -> constr -> information
val type_of_mind : 'c evar_map -> environment -> constr -> type_judgement
val type_of_mconstr : 'b evar_map -> environment -> constr -> constr
val type_of_case :  'c evar_map -> environment ->
  judgement -> judgement -> judgement array -> judgement
val verify_wf_env : environment -> unit
val cast_of_judgement : judgement -> constr


(* Pour Progmach *)
val hyp_seq_ordered_inclusion : context -> context -> bool

val lookup_exist : 'b evar_map -> (type_judgement, 'c) env -> section_path -> constr
val global_reference : (type_judgement, 'c) env -> section_path -> identifier -> constr
val global_reference1 :
  (type_judgement, 'c) env -> section_path -> identifier -> (constr * int list)
val search_reference : (type_judgement, 'c) env -> identifier -> constr
val search_reference1 : (type_judgement, 'c) env -> identifier -> (constr * int list)
val search_freference : (type_judgement, 'c) env -> identifier -> constr
val search_freference1 : (type_judgement, 'c) env -> identifier -> (constr * int list)
val search : (type_judgement, 'c) env -> identifier -> constr
val global : (type_judgement, 'c) env -> identifier -> constr

(* $Id: machops.mli,v 1.8 1999/08/06 20:49:14 herbelin Exp $ *)
