(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                               printer.mli                                *)
(****************************************************************************)

open Pp
open Names
open Term
open Constrtypes
open Evd

val gencompr        : path_kind -> CoqAst.t -> std_ppcmds
val gentermpr       : path_kind -> 'a assumptions -> constr -> std_ppcmds
val gentacpr        : CoqAst.t -> std_ppcmds
val prterm          : constr -> std_ppcmds
val prtype_env      : 'a assumptions -> type_judgement -> std_ppcmds
val prtype          : type_judgement -> std_ppcmds
val fprterm         : constr -> std_ppcmds
val fprtype_env     : 'a assumptions -> type_judgement -> std_ppcmds
val fprtype         : type_judgement -> std_ppcmds
val fterm0          : 'a assumptions -> constr -> std_ppcmds
val term0           : 'a assumptions -> constr -> std_ppcmds
val term0_at_top    : 'a assumptions -> constr -> std_ppcmds
val pr_env          : path_kind -> environment -> std_ppcmds
val pr_ne_env       : std_ppcmds -> path_kind -> environment -> std_ppcmds
val pr_env_opt      : environment -> std_ppcmds
val print_arguments : bool ref
val print_casts     : bool ref
val print_emacs     : bool ref
val with_implicits  : ('a -> 'b) -> 'a -> 'b
val pr_sign         : context -> std_ppcmds

val emacs_str       : string -> string

(* $Id: printer.mli,v 1.12 1999/09/08 12:34:44 herbelin Exp $ *)
