(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                typing.mli                                *)
(****************************************************************************)

open Names
open Pp
open Term
open Constrtypes
open Termenv
open Evd

exception Singleton

(* Invariant: We have 
   -- hnf (fullmind) = DOPN(AppL,[|coremind;..params..;..proper_args..|])
   -- with coremind  = MutInd ((sp,i),localvar) for some sp, i, localvars
 *)
type mutind =
    {fullmind:constr;
     mind:constr;
     nparams:int;
     nconstr:int;
     globargs:constr list;
     realargs:constr list;
     arity:constr};;

(* [try_mutind_of sigma t] raise Induc if [t] is not an inductive type *)
val try_mutind_of : 'a Evd.evar_map -> constr -> mutind

(* [mutind_of sigma env (c,t)] generates an error explaining [c] is
   not of an inductive type in context [env]
val mutind_of : 'a Evd.evar_map -> environment -> constr * constr -> mutind
 *)

val mis_type_mconstructs : Termenv.mind_specif -> constr array * constr array 
val type_mconstructs :
  'a Evd.evar_map -> constr -> constr array * constr array 
val mis_type_mconstruct : int -> Termenv.mind_specif -> constr 
val type_mconstruct : 'a Evd.evar_map -> int -> constr -> constr 
val type_inst_construct : 'a Evd.evar_map -> int -> constr -> constr 
val is_correct_arity_dep :
  'a Evd.evar_map -> sorts list -> constr -> constr * constr -> bool 
val is_correct_arity_nodep :
  'a Evd.evar_map ->
  sorts list -> constr * constr -> bool 
val make_arity_dep : constr -> constr -> constr -> constr 
val make_arity_nodep : constr -> constr -> constr 
val error_elim_expln : constr -> constr -> string 
exception Arity of (constr * constr * string) option
val is_correct_arity :
  'a assumptions ->
  'b Evd.evar_map ->
  sorts list ->
  sorts list ->
  constr * constr ->
  constr -> constr * constr -> bool * constr 

val find_case_dep_nparams :
  'a assumptions ->
  'b Evd.evar_map ->
  constr * constr ->
  constr * constr list ->
  constr -> bool * (int * constr list * constr list) 

val find_case_dep_mis :
  'a assumptions ->
  'b Evd.evar_map ->
  'c ->
  constr * constr ->
  constr * constr list -> constr -> bool 
val type_one_branch_dep :
  'a Evd.evar_map * int * constr list *
  constr ->
  constr -> constr -> constr 
val type_one_branch_nodep :
  'a Evd.evar_map * int * constr list *
  constr -> constr -> constr 
  
val type_case_branches :
  'a assumptions ->
  'b Evd.evar_map ->
  constr ->
  constr ->
  constr ->
  constr -> constr * constr array * constr 
val type_case :
  'a assumptions ->
  'b Evd.evar_map ->
  constr ->
  constr -> constr -> constr -> constr 
val check_branches_message :
  'a assumptions ->
  'b Evd.evar_map ->
  constr * constr ->
  constr array * constr array -> unit 
val sort_of_arity : 'a Evd.evar_map -> constr -> constr 
  
val sort_of_product : sorts -> sorts -> sorts
val sort_of_product1 : constr -> sorts -> sorts
val type_of_product : constr -> constr -> constr

val type_of_sort : constr -> constr 
  
val type_fixpoint :
  'a Evd.evar_map ->
  Names.name list -> type_judgement array -> judgement array -> unit 
  
exception NotFound
val find_sorted_assoc : 'a -> ('a * 'b) list -> 'b 
val map_lift_fst :    (int * Constrtypes.recarg list array) list ->
    (int * Constrtypes.recarg list array) list
val check_term :
  Constrtypes.recarg list array array ->
  (int ->
   (int * Constrtypes.recarg list array) list -> constr -> 'a) ->
  int ->
  (int * Constrtypes.recarg list array) list ->
  Constrtypes.recarg list * constr -> 'a 
val is_inst_var : 'a Evd.evar_map -> int -> constr -> bool 
val is_subterm_specif :
  'a Evd.evar_map ->
  Constrtypes.recarg list array ->
  Constrtypes.recarg list array array ->
  int ->
  (int * Constrtypes.recarg list array) list ->
  constr -> Constrtypes.recarg list array 
val is_subterm :
  'a Evd.evar_map ->
  Constrtypes.recarg list array ->
  Constrtypes.recarg list array array ->
  int ->
  (int * Constrtypes.recarg list array) list -> constr -> bool 
  
val noccur_with_meta : 'a Evd.evar_map -> int -> int -> constr -> bool 
val check_subterm_rec_meta : 'a Evd.evar_map -> int array -> int -> constr -> bool 
val check_fix : 'a Evd.evar_map -> constr -> unit 
val check_guard_rec : 'a Evd.evar_map -> int -> constr -> constr -> bool 
val check_guard_rec_meta : 'a Evd.evar_map -> int -> constr -> constr -> bool 
val check_cofix : 'a Evd.evar_map -> constr -> unit 
val control_only_guard : 'a Evd.evar_map -> constr -> unit


(* $Id: typing.mli,v 1.9 1999/10/22 12:49:22 herbelin Exp $ *)
