(**************************************************************************
  *********                     ntdef.ml                          *********
  **************************************************************************)

open Generic;;
open Names;;
open Std;;
open More_util;;
open Tutil;;
(* Rajoute' lors de la traduction en o'caml HH *)
open Term;;          (* pq ca marchait avant ? *)

type natural_oper = (sorts oper, annotation) union
 and natural_constr = natural_oper term
 and annotation = {(*from father*)
                   mutable n_a : n_arg;
                  mutable n_t : n_type;
                  mutable n_d : n_dot;
                  (*shortcut*)
                  mutable n_j : n_jump;
                  (*from itself*)
                  mutable n_i : n_info;
                  mutable n_f : n_format}
 and n_arg =   Na
             | Na_lambda_son of nt_lambda_son
             | Na_app_son of bool * nt_app_son_apply * nt_app_son_elim
             | Na_fix_son of nt_fix_son
 and n_dot = bool
 and n_type = (*expected*)
               bool * (*use*) bool * (*use_first*) bool * constr list
 and n_jump = int option
 and n_info =   Ni
              | Ni_lambda of nt_lambda_data * nt_lambda_data_elim option *
                             nt_lambda_use_count
              | Ni_app of (nt_app_data_apply * nt_app_data_elim option) *
                          nt_app_use_count
              | Ni_fix of nt_fix_data
              | Ni_metavar of nt_metavar_data
              | Ni_id of nt_id_data
 and n_format = (*Up*)
                 (bool * (*Dn*) bool) * (char * string * int) list
 and nt_lambda_data = nt_sort * (nt_occ * nt_occ) * nt_lambda_in_case
 and nt_lambda_data_elim = constr
 and nt_lambda_use_count = (*in_case*)
                            (bool * (*link*) nt_lambda_link * (*coord*) nt_coord) *
                            (nt_lambda_nat * nt_lambda_link_count)
 and nt_sort =   Ns_Prop
               | Ns_Set
               | Ns_Type
               | Ns_TypeSet
 and nt_occ =   No0
              | No1
              | NoS
 and nt_lambda_in_case = bool option
 and nt_lambda_link =   Nll_type
                      | Nll_sort
                      | Nll_sentence
                      | Nll_none
 and nt_lambda_link_count = int * int * int
 and nt_coord =   Nc_misc
                | Nc_such_that
 and nt_lambda_nat =   Nln_std
                     | Nln_triv
                     | Nln_not
                     | Nln_abs
                     | Nln_noocc
 and nt_lambda_son =   Nls_std
                     | Nls_triv
                     | Nls_not
                     | Nls_abs
                     | Nls_noocc
 and nt_app_data_apply = (*construct*)
                          bool * (*omit*) bool *
                          (*sub*)
                          (bool * (*wit*) bool * (*obv*) bool * (*dep*) bool)
 and nt_app_data_elim = (*induc*)
                         bool * (*omit *) bool * (*cst*) constr
 and nt_app_use_count =   Nauc_apply of (*construct*)
                                        (bool * (*omit*) (bool * (*pos*) nt_pos)) *
                                        (*ident*)
                                        (nt_is_ident *
                                         (*ident*)
                                         (nt_is_ident * (*n_subs*) int))
                        | Nauc_elim of (*induc*)
                                       (bool * (*omit*) bool) *
                                       (*ident*)
                                       (nt_is_ident * (*n_cases*) int *
                                        (int * int * int))
 and nt_pos =   Up
              | Dn
 and nt_is_ident =   Nii_not
                   | Nii_id of (*imm*)
                               bool
 and nt_app_son_apply =   Nasa_head
                        | Nasa_sub of (*recur*)
                                      (nt_is_ident * int) option *
                                      (*n_right*) int
                        | Nasa_wit
                        | Nasa_obv
                        | Nasa_dep
 and nt_app_son_elim =   Nase
                       | Nase_prop
                       | Nase_destruct of (*dep*)
                                          bool
                       | Nase_case of (*recur*)
                                      bool * (*induc elim *) bool option *
                                      (*nbr_lambdas*) int * nt_case_nat *
                                      nt_case_number option
 and nt_fix_data = int
 and nt_fix_son = identifier * constr
 and nt_metavar_data = goal_path
 and goal_path = int list
 and nt_id_data = nt_id_nat
 and nt_id_nat =   Nin
                 | Nin_var of bool
                 | Nin_theorem
                 | Nin_axiom
                 | Nin_construct of constr
                 | Nin_elim_theorem of constr
 and nt_case_number = int list
 and nt_case_nat =   Ncn_std
                   | Ncn_triv
                   | Ncn_abs
                   | Ncn_base
                   | Ncn_induc;;

type nt_definition =
       N_prooftext of string * identifier * natural_constr * constr
     | N_definition of string * identifier * constr * constr
     | N_axiom of string * identifier * constr;;


(**************************************************************************
  **************************************************************************)
let d_n_a = Na;;

let d_n_t = false, false, true, [];;

let d_n_d = false;;

let d_n_j = None;;

let d_n_i = Ni;;

let d_n_f = 
 (true, false), [];;

let make_annotation n_a n_t n_d n_j n_i n_f =
 {n_a = n_a; n_t = n_t; n_d = n_d; n_j = n_j; n_i = n_i; n_f = n_f};;

let rec nc_jump nc =
 match nc with
 | DOP1 ((Inr ({n_j=Some i})),
           (DOP2 (_, _, (DLAM (_, (DOP1 (_, (DOPN (_, v))))))))) ->
  nc_jump v.(i)
 | _ -> nc;;

let rec nc_jump_fun nc =
 match nc with
 | DOP1 ((Inr ({n_j=Some i}) as op1),
           (DOP2 (op2, typ, (DLAM (na, (DOP1 (op3, (DOPN (op4, v))))))))) ->
  let f_body, body = nc_jump_fun v.(i) in
  
   (function body' -> if body == body' then nc
                       else begin
                        let v' = Array.copy v in
                        v'.(i) <- body';
                        DOP1
                         (op1,
                         DOP2 (op2, typ, DLAM (na, DOP1 (op3, DOPN (op4, v')))))
                      end), body
 | _ -> 
         (function nc -> nc), nc;;

let rec nc_jump_count nc =
 match nc with
 | DOP1 ((Inr ({n_j=Some i})),
           (DOP2 (_, _, (DLAM (_, (DOP1 (_, (DOPN (_, v))))))))) ->
  let n, nc = nc_jump_count v.(i) in
  n + 1, nc
 | _ -> 0, nc;;

let nc_set_n_a n_a =
 function
    | DOP1 ((Inr an), _) -> an.n_a <- n_a
    | _ -> ();;

let nc_set_n_t n_t =
 function
    | DOP1 ((Inr an), _) -> an.n_t <- n_t
    | _ -> ();;

let nc_set_n_d n_d =
 function
    | DOP1 ((Inr an), _) -> an.n_d <- n_d
    | _ -> ();;

let nc_set_n_j n_j =
 function
    | DOP1 ((Inr an), _) -> an.n_j <- n_j
    | _ -> ();;

let nc_set_n_i n_i nc =
 match nc_jump nc with
 | DOP1 ((Inr an), _) -> an.n_i <- n_i
 | _ -> ();;

let nc_set_n_f n_f nc =
 match nc_jump nc with
 | DOP1 ((Inr an), _) -> an.n_f <- n_f
 | _ -> ();;

let nc_get_n_a =
 function
    | DOP1 ((Inr an), _) -> an.n_a
    | _ -> d_n_a;;

let nc_get_n_t =
 function
    | DOP1 ((Inr an), _) -> an.n_t
    | _ -> d_n_t;;

let nc_get_n_d =
 function
    | DOP1 ((Inr an), _) -> an.n_d
    | _ -> d_n_d;;

let nc_get_n_j =
 function
    | DOP1 ((Inr an), _) -> an.n_j
    | _ -> d_n_j;;

let nc_get_n_i nc =
 match nc_jump nc with
 | DOP1 ((Inr an), _) -> an.n_i
 | _ -> d_n_i;;

let nc_get_n_f nc =
 match nc_jump nc with
 | DOP1 ((Inr an), _) -> an.n_f
 | _ -> d_n_f;;

(**************************************************************************
  **************************************************************************)
let nc_body nc =
 match nc_jump nc with
 | DOP1 ((Inr _), nc) -> nc
 | nc -> nc;;

let nc_note =
 function
    | DOP1 ((Inr n), _) -> Some n
    | _ -> None;;

let natural_oper_of_sorts_oper op = Inl op;;

let sorts_oper_of_natural_oper =
 function
    | Inl op -> op
    | Inr _ -> error "sorts_oper_of_natural_oper";;

let nc_of_c c = map_oper natural_oper_of_sorts_oper c;;

let rec nc_strip_outer_annotation =
 function
    | DOP1 ((Inr _), nc) -> nc_strip_outer_annotation nc
    | nc -> nc;;

let c_of_nc nc =
 let nc = apply_top_down nc_strip_outer_annotation nc in
 map_oper sorts_oper_of_natural_oper nc;;

(**************************************************************************
  **************************************************************************)
let rec nc_f_R_to_V idl nc =
 match nc with
 | Rel i -> begin
   try VAR (List.nth idl (i - 1))
   with
   | Failure "nth" -> Rel i
 end
 | VAR id -> VAR id
 | DOP0 op -> DOP0 op
 | DOP1 ((Inl _ as op), c1) -> DOP1 (op, nc_f_R_to_V idl c1)
 | DOP1 ((Inr an as op), c1) ->
  ((function
       expexpted, use, use_first, l ->
    an.n_t <- expexpted, use, use_first, List.map (f_R_to_V idl) l) (an.n_t));
  (match an.n_a with
   | Na_fix_son (na, t) -> an.n_a <- Na_fix_son (na, f_R_to_V idl t)
   | _ -> ());
  DOP1 (op, nc_f_R_to_V idl c1)
 | DOP2 (op, c1, c2) -> DOP2 (op, nc_f_R_to_V idl c1, nc_f_R_to_V idl c2)
 | DOPL (op, l) -> DOPL (op, List.map (nc_f_R_to_V idl) l)
 | DOPN (op, v) -> DOPN (op, Array.map (nc_f_R_to_V idl) v)
 | DLAM ((Name id), c) ->
  let id = next_ident_away id idl in
  DLAM (Name id, nc_f_R_to_V (id::idl) c)
 | DLAM (Anonymous, c) -> DLAM (Anonymous, nc_f_R_to_V (def_id::idl) c)
 | DLAMV ((Name id), v) ->
  let id = next_ident_away id idl in
  DLAMV (Name id, Array.map (nc_f_R_to_V (id::idl)) v)
 | DLAMV (Anonymous, v) ->
  DLAMV (Anonymous, Array.map (nc_f_R_to_V (def_id::idl)) v);;

let rec nc_f_V_to_R idl nc =
 match nc with
 | Rel i -> Rel i
 | VAR id -> begin
   try Rel (index id idl)
   with
   | Failure "index" -> VAR id
 end
 | DOP0 op -> DOP0 op
 | DOP1 ((Inl _ as op), c1) -> DOP1 (op, nc_f_V_to_R idl c1)
 | DOP1 ((Inr an as op), c1) ->
  ((function
       expexpted, use, use_first, l ->
    an.n_t <- expexpted, use, use_first, List.map (f_V_to_R idl) l) (an.n_t));
  (match an.n_a with
   | Na_fix_son (na, t) -> an.n_a <- Na_fix_son (na, f_V_to_R idl t)
   | _ -> ());
  DOP1 (op, nc_f_V_to_R idl c1)
 | DOP2 (op, c1, c2) -> DOP2 (op, nc_f_V_to_R idl c1, nc_f_V_to_R idl c2)
 | DOPL (op, l) -> DOPL (op, List.map (nc_f_V_to_R idl) l)
 | DOPN (op, v) -> DOPN (op, Array.map (nc_f_V_to_R idl) v)
 | DLAM ((Name id), c) -> DLAM (Name id, nc_f_V_to_R (id::idl) c)
 | DLAM (Anonymous, c) -> DLAM (Anonymous, nc_f_V_to_R (def_id::idl) c)
 | DLAMV ((Name id), v) -> DLAMV (Name id, Array.map (nc_f_V_to_R (id::idl)) v)
 | DLAMV (Anonymous, v) ->
  DLAMV (Anonymous, Array.map (nc_f_V_to_R (def_id::idl)) v);;

let nc_from_Rel_to_VAR nc = nc_f_R_to_V [] nc;;

let nc_from_VAR_to_Rel nc = nc_f_V_to_R [] nc;;

let def_from_Rel_to_VAR =
 function
    | N_prooftext (str, id, nc, typ) ->
     N_prooftext (str, id, nc_from_Rel_to_VAR nc, from_Rel_to_VAR typ)
    | N_definition (str, id, c, typ) ->
     N_definition (str, id, from_Rel_to_VAR c, from_Rel_to_VAR typ)
    | N_axiom (str, id, typ) -> N_axiom (str, id, from_Rel_to_VAR typ);;

let def_from_VAR_to_Rel =
 function
    | N_prooftext (str, id, nc, typ) ->
     N_prooftext (str, id, nc_from_VAR_to_Rel nc, from_VAR_to_Rel typ)
    | N_definition (str, id, c, typ) ->
     N_definition (str, id, from_VAR_to_Rel c, from_VAR_to_Rel typ)
    | N_axiom (str, id, typ) -> N_axiom (str, id, from_VAR_to_Rel typ);;

