(**************************************************************************
  *********                  ntformat.ml                          *********
  **************************************************************************)
open Std;;
open Ntdef;;
open Ntaux;;
open Ntsons;;

(**************************************************************************
  **                          no type no pos                             **
  **************************************************************************)
let nc_loc_format_no_type_no_pos nc =
 begin
   let some_type = nc_number_of_types nc > 0 in
   (function pos, l -> if some_type & pos = (false, false) then nc_set_n_f (
                        (true, false), l) nc
                        else
                        if (not (some_type)) & (not (pos = (false, false))) then
                        nc_set_n_f (
                        (false, false), l) nc) (nc_get_n_f nc)
 end; match nc_get_n_i nc with
 | Ni_app (datas,
             (Nauc_apply ((construct, (omit_h, pos)),
                            (id_h, (id_subs, n_subs) as count)))) ->
  if n_subs > 0 & (not (omit_h)) then begin
    let pos' =
     match id_h, id_subs with
     | (Nii_id _), (Nii_id _) -> Dn
     | (Nii_id _), Nii_not -> Dn
     | Nii_not, (Nii_id _) -> Up
     | Nii_not, Nii_not -> pos in
    if pos <> pos' then nc_set_n_i (Ni_app (datas, Nauc_apply (
                                                    (construct, 
                                                     (omit_h, pos')), count)))
     nc
  end
 | _ -> ();;

(**************************************************************************
  **                            dot                                      **
  **************************************************************************)
let nc_loc_format_dot nc =
 let dot =
  match nc_get_n_i nc with
  | Ni_app (_, (Nauc_apply ((_, (omit_h, _)), (id_h, (id_subs, n_subs))))) ->
   (match id_h, omit_h, id_subs, n_subs with
   | _, _, _, 0 -> false
   | _, _, (Nii_id _), _ -> false
   | (Nii_id _), _, _, 1 -> false
   | _, true, _, 1 -> false
   | _ -> true)
  | _ -> false in
 List.iter (function nc -> begin
   try nc_set_n_d dot nc
   with
   | UserError ("ntdef__nc_set_n_d", _) -> ()
 end) (nc_sons nc);;

(**************************************************************************
  **                            main                                     **
  **************************************************************************)
let nc_loc_format_main nc =
 let (type_up, type_dn), _ = nc_get_n_f nc in
 let n_f =
  match nc_get_n_i nc with
  | (**************************************************************************
      *******************           lambda                  *******************
      **************************************************************************)
    Ni_lambda _ ->
   (match type_up, type_dn with
   | false, false -> ['D', "IL", "    "; 'M', "BL", ""]
   | false, true -> ['T', "IL", "    "; 'M', "BL", "I"; 'D', "CL", "T   "]
   | true, false -> ['D', "IL", "T   "; 'M', "BL", ""]
   | true, true -> ['T', "IL", "T   "; 'M', "BL", ""; 'D', "CL", "T   "])
  | (**************************************************************************
      *************************************************************************
      *******************               apply               *******************
      *************************************************************************
      **************************************************************************)
    Ni_app (_,
              (Nauc_apply ((head_construct, (head_omit, head_pos)),
                             (head_id, (sub_id, sub_num))))) ->
   let some_type = type_up || type_dn in
   (match head_construct with
    | false ->
     (match sub_num with
     | 0 ->
      (match head_omit with
      | (**************************************************************************
          *******************       apply std specialization    *******************
          **************************************************************************)
        false ->
       (match head_id with
       | Nii_not ->
        (match type_up, type_dn with
        | false, false -> ['T', "HA", ""; 'D', "CASsp", "    "]
        | false, true -> ['T', "HA", ""; 'D', "CASsp", "T   "]
        | true, false ->
         ['T', "IAS", "T   "; 'M', "HA", ""; 'D', "CASsp", "    "]
        | true, true ->
         ['T', "IAS", "T   "; 'M', "HA", ""; 'D', "CASsp", "T   "])
       | Nii_id _ ->
        (match type_up || type_dn with
        | false -> ['D', "CASsp", " H  "]
        | true -> ['D', "CASsp", "TH  "]))
      | (**************************************************************************
          *******************     apply omit specialization     *******************
          **************************************************************************)
        true ->
       (match type_up || type_dn with
       | false -> ['D', "CAOsp", "    "]
       | true -> ['D', "CAOsp", "T   "]))
     | _ ->
      (match head_omit with
      | (**************************************************************************
          *******************             apply std             *******************
          **************************************************************************)
        false ->
       (match sub_id with
       | Nii_not ->
        (match head_id with
        | Nii_not ->
         (match type_up, type_dn with
         | false, false ->
          (match head_pos with
          | Dn -> ['T', "HA", ""; 'M', "BA", ""; 'D', "CAS", "    "]
          | Up -> ['T', "BA", ""; 'M', "HA", ""; 'D', "CAS", "    "])
         | false, true ->
          (match head_pos with
          | Dn -> ['T', "BA", ""; 'M', "HA", ""; 'D', "CAS", "T   "]
          | Up -> ['T', "HA", ""; 'M', "BA", ""; 'D', "CAS", "T   "])
         | true, false ->
          (match head_pos with
          | Dn ->
           ['T', "IAS", "T   "; 'M', "BA", ""; 'M', "HA", ""; 'D', "CAS", "    "]
          | Up ->
           ['T', "IAS", "T   "; 'M', "HA", ""; 'M', "BA", ""; 'D', "CAS", "    "])
         | true, true ->
          (match head_pos with
          | Dn ->
           ['T', "IAS", "T   "; 'M', "BA", ""; 'M', "HA", ""; 'D', "CAS", "T   "]
          | Up ->
           ['T', "IAS", "T   "; 'M', "HA", ""; 'M', "BA", ""; 'D', "CAS", "T   "]))
        | Nii_id _ ->
         (match type_up, type_dn with
         | false, false -> ['T', "BA", ""; 'D', "CAS", " H  "]
         | false, true -> ['T', "BA", ""; 'D', "CAS", "TH  "]
         | true, false ->
          (match head_pos with
          | Dn -> ['T', "IAS", "T   "; 'M', "BA", ""; 'D', "CAS", " H  "]
          | Up -> ['D', "IAS", "TH  "; 'M', "BA", ""])
         | true, true ->
          (match head_pos with
          | Dn -> ['T', "IAS", "T   "; 'M', "BA", ""; 'D', "CAS", "TH  "]
          | Up -> ['T', "IAS", "TH  "; 'M', "BA", ""; 'D', "CAS", "T   "])))
       | Nii_id _ ->
        (match head_id with
        | Nii_not ->
         (match type_up, type_dn with
         | false, false -> ['T', "HA", ""; 'D', "CAS", "  A "]
         | false, true -> ['T', "HA", ""; 'D', "CAS", "T A "]
         | true, false ->
          ['T', "IAS", "T   "; 'M', "HA", ""; 'D', "CAS", "  A "]
         | true, true -> ['T', "IAS", "T   "; 'M', "HA", ""; 'D', "CAS", "T A "])
        | Nii_id _ ->
         (match type_up || type_dn with
         | false -> ['D', "CAS", " HA "]
         | true -> ['D', "CAS", "THA "])))
      | (**************************************************************************
          *******************             apply omit            *******************
          **************************************************************************)
        true ->
       (match sub_id with
       | Nii_not ->
        (match type_up, type_dn with
        | false, false -> ['D', "BA", ""]
        | false, true -> ['T', "BA", ""; 'D', "CAO", "T   "]
        | true, false -> ['D', "IAO", "T   "; 'M', "BA", ""]
        | true, true -> ['T', "IAO", "T   "; 'M', "BA", ""; 'D', "CAO", "T   "])
       | Nii_id _ ->
        (match type_up || type_dn with
        | false -> ['D', "CAO", "  A "]
        | true -> ['D', "CAO", "T A "]))))
    | true ->
     (match sub_num with
     | 0 ->
      (match head_omit with
      | (**************************************************************************
          *******************   apply construct specialization  *******************
          **************************************************************************)
        false ->
       (match type_up || type_dn with
       | false -> ['D', "CACsp", " H  "]
       | true -> ['D', "CACsp", "TH  "])
      | (**************************************************************************
          *****************  apply construct omit specialization ******************
          **************************************************************************)
        true ->
       (match type_up || type_dn with
       | false -> ['D', "CAOsp", "    "]
       | true -> ['D', "CAOsp", "T   "]))
     | _ ->
      (match head_omit with
      | (**************************************************************************
          *******************             apply construct       *******************
          **************************************************************************)
        false ->
       (match sub_id with
       | Nii_not ->
        (match type_up, type_dn with
        | false, false -> ['T', "BA", ""; 'D', "CAC", " H  "]
        | false, true -> ['T', "BA", ""; 'D', "CAC", "TH  "]
        | true, false ->
         (match head_pos with
         | Dn -> ['T', "IAC", "T   "; 'M', "BA", ""; 'D', "CAC", " H  "]
         | Up -> ['D', "IAC", "TH  "; 'M', "BA", ""])
        | true, true ->
         (match head_pos with
         | Dn -> ['T', "IAC", "T   "; 'M', "BA", ""; 'D', "CAC", "TH  "]
         | Up -> ['T', "IAC", "TH  "; 'M', "BA", ""; 'D', "CAC", "T   "]))
       | Nii_id _ ->
        (match type_up || type_dn with
        | false -> ['D', "CAC", " HA "]
        | true -> ['D', "CAC", "THA "]))
      | (**************************************************************************
          *******************       apply construct omit        *******************
          **************************************************************************)
        true ->
       (match sub_id with
       | Nii_not ->
        (match type_up, type_dn with
        | false, false -> ['D', "BA", ""]
        | false, true -> ['T', "BA", ""; 'D', "CAO", "T   "]
        | true, false -> ['D', "IAO", "T   "; 'M', "BA", ""]
        | true, true -> ['T', "IAO", "T   "; 'M', "BA", ""; 'D', "CAO", "T   "])
       | Nii_id _ ->
        (match type_up || type_dn with
        | false -> ['D', "CAO", "  A "]
        | true -> ['D', "CAO", "T A "])))))
  | (**************************************************************************
      *************************************************************************
      *******************               elim                *******************
      *************************************************************************
      **************************************************************************)
    Ni_app (_, (Nauc_elim ((induc, omit), (head_id, n_case, (n_1, n_2, n_3))))) ->
   (match induc with
   | false ->
    (match n_case with
    | (**************************************************************************
        *******************        elim match no case         *******************
        **************************************************************************)
      0 ->
     (match head_id with
     | Nii_not ->
      (match omit with
      | false ->
       (match type_up || type_dn with
       | false -> ['T', "HE", ""; 'D', "CEM0", " C  "]
       | true -> ['T', "HE", ""; 'D', "CEM0", "TC  "])
      | true ->
       (match type_up || type_dn with
       | false -> ['D', "HE", ""]
       | true -> ['T', "HE", ""; 'D', "CEM0", "T   "]))
     | Nii_id _ ->
      (match omit with
      | false ->
       (match type_up || type_dn with
       | false -> ['D', "CEM0", " CH "]
       | true -> ['D', "CEM0", "TCH "])
      | true ->
       (match type_up || type_dn with
       | false -> ['D', "CEM0", "  H "]
       | true -> ['D', "CEM0", "T H "])))
    | _ ->
     (match n_1, n_2, n_3 with
     | (**************************************************************************
         *******************        elim match trivial         *******************
         **************************************************************************)
       0, _, 0 ->
      (match head_id with
      | Nii_not ->
       (match omit with
       | false ->
        (match type_up || type_dn with
        | false -> ['T', "HE", ""; 'D', "CEMtr", " C  "]
        | true -> ['T', "HE", ""; 'D', "CEMtr", "TC  "])
       | true ->
        (match type_up || type_dn with
        | false -> ['D', "HE", ""]
        | true -> ['T', "HE", ""; 'D', "CEMtr", "T   "]))
      | Nii_id _ ->
       (match omit with
       | false ->
        (match type_up || type_dn with
        | false -> ['D', "CEMtr", " CH "]
        | true -> ['D', "CEMtr", "TCH "])
       | true ->
        (match type_up || type_dn with
        | false -> ['D', "CEMtr", "  H "]
        | true -> ['D', "CEMtr", "T H "])))
     | (**************************************************************************
         *******************          elim match one           *******************
         **************************************************************************)
       1, 0, 0 | 0, 0, 1 ->
      (match head_id with
      | Nii_not ->
       (match omit with
       | false ->
        (match type_up, type_dn with
        | false, false -> ['T', "HE", ""; 'D', "IEM1", " C  "; 'M', "BE", ""]
        | false, true ->
         ['T', "HE", ""; 'M', "IEM1", " C  "; 'M', "BE", ""; 'D', "CEM1", "T   "]
        | true, false -> ['T', "HE", ""; 'D', "IEM1", "TC  "; 'M', "BE", ""]
        | true, true ->
         ['T', "HE", ""; 'M', "IEM1", "TC  "; 'M', "BE", ""; 'D', "CEM1", "T   "])
       | true ->
        (match type_up, type_dn with
        | false, false -> ['T', "HE", ""; 'D', "IEM1", "    "; 'M', "BE", ""]
        | false, true ->
         ['T', "HE", ""; 'M', "IEM1", "    "; 'M', "BE", ""; 'D', "CEM1", "T   "]
        | true, false -> ['T', "HE", ""; 'D', "IEM1", "T   "; 'M', "BE", ""]
        | true, true ->
         ['T', "HE", ""; 'M', "IEM", "T   "; 'M', "BE", ""; 'D', "CEM1", "T   "]))
      | Nii_id _ ->
       (match omit with
       | false ->
        (match type_up, type_dn with
        | false, false -> ['D', "IEM1", " CH "; 'M', "BE", ""]
        | false, true ->
         ['T', "IEM1", " CH "; 'M', "BE", ""; 'D', "CEM1", "T   "]
        | true, false -> ['D', "IEM1", "TCH "; 'M', "BE", ""]
        | true, true ->
         ['T', "IEM1", "TCH "; 'M', "BE", ""; 'D', "CEM1", "T   "])
       | true ->
        (match type_up, type_dn with
        | false, false -> ['D', "IEM1", "  H "; 'M', "BE", ""]
        | false, true ->
         ['T', "IEM1", "  H "; 'M', "BE", ""; 'D', "CEM1", "T   "]
        | true, false -> ['D', "IEM1", "T H "; 'M', "BE", ""]
        | true, true ->
         ['T', "IEM1", "T H "; 'M', "BE", ""; 'D', "CEM1", "T   "])))
     | (**************************************************************************
         *******************        elim match absurd          *******************
         **************************************************************************)
       0, 0, _ ->
      (match head_id with
      | Nii_not ->
       (match omit with
       | false ->
        (match type_up, type_dn with
        | false, false -> ['T', "HE", ""; 'D', "IEMabs", "    "; 'M', "BE", ""]
        | false, true ->
         ['T', "HE", "";
         'M', "IEMabs", "    "; 'M', "BE", ""; 'D', "CEMabs", "T   "]
        | true, false -> ['D', "IAO", "T   "; 'M', "BA", ""]
        | true, true -> ['T', "IAO", "T   "; 'M', "BA", ""; 'D', "CAO", "T   "])
       | true ->
        (match type_up, type_dn with
        | false, false -> ['T', "HE", ""; 'D', "IEMabs", "    "; 'M', "BE", ""]
        | false, true ->
         ['T', "HE", "";
         'M', "IEMabs", "    "; 'M', "BE", ""; 'D', "CEMabs", "T   "]
        | true, false -> ['D', "IAO", "T   "; 'M', "BA", ""]
        | true, true -> ['T', "IAO", "T   "; 'M', "BA", ""; 'D', "CAO", "T   "]))
      | Nii_id _ ->
       (match omit with
       | false ->
        (match type_up, type_dn with
        | false, false -> ['T', "HE", ""; 'D', "IEMabs", "    "; 'M', "BE", ""]
        | false, true ->
         ['T', "HE", "";
         'M', "IEMabs", "    "; 'M', "BE", ""; 'D', "CEMabs", "T   "]
        | true, false -> ['D', "IAO", "T   "; 'M', "BA", ""]
        | true, true -> ['T', "IAO", "T   "; 'M', "BA", ""; 'D', "CAO", "T   "])
       | true ->
        (match type_up, type_dn with
        | false, false -> ['T', "HE", ""; 'D', "IEMabs", "    "; 'M', "BE", ""]
        | false, true ->
         ['T', "HE", "";
         'M', "IEMabs", "    "; 'M', "BE", ""; 'D', "CEMabs", "T   "]
        | true, false -> ['D', "IAO", "T   "; 'M', "BA", ""]
        | true, true -> ['T', "IAO", "T   "; 'M', "BA", ""; 'D', "CAO", "T   "])))
     | (**************************************************************************
         *******************           elim match              *******************
         **************************************************************************)
       _ ->
      (match head_id with
      | Nii_not ->
       (match omit with
       | false ->
        (match type_up, type_dn with
        | false, false -> ['T', "HE", ""; 'D', "IEM", " C  "; 'M', "BE", ""]
        | false, true ->
         ['T', "HE", ""; 'M', "IEM", " C  "; 'M', "BE", ""; 'D', "CEM", "T   "]
        | true, false -> ['T', "HE", ""; 'D', "IEM", "TC  "; 'M', "BE", ""]
        | true, true ->
         ['T', "HE", ""; 'M', "IEM", "TC  "; 'M', "BE", ""; 'D', "CEM", "T   "])
       | true ->
        (match type_up, type_dn with
        | false, false -> ['T', "HE", ""; 'D', "IEM", "    "; 'M', "BE", ""]
        | false, true ->
         ['T', "HE", ""; 'M', "IEM", "    "; 'M', "BE", ""; 'D', "CEM", "T   "]
        | true, false -> ['T', "HE", ""; 'D', "IEM", "T   "; 'M', "BE", ""]
        | true, true ->
         ['T', "HE", ""; 'M', "IEM", "T   "; 'M', "BE", ""; 'D', "CEM", "T   "]))
      | Nii_id _ ->
       (match omit with
       | false ->
        (match type_up, type_dn with
        | false, false -> ['D', "IEM", " CH "; 'M', "BE", ""]
        | false, true -> ['T', "IEM", " CH "; 'M', "BE", ""; 'D', "CEM", "T   "]
        | true, false -> ['D', "IEM", "TCH "; 'M', "BE", ""]
        | true, true -> ['T', "IEM", "TCH "; 'M', "BE", ""; 'D', "CEM", "T   "])
       | true ->
        (match type_up, type_dn with
        | false, false -> ['D', "IEM", "  H "; 'M', "BE", ""]
        | false, true -> ['T', "IEM", "  H "; 'M', "BE", ""; 'D', "CEM", "T   "]
        | true, false -> ['D', "IEM", "T H "; 'M', "BE", ""]
        | true, true -> ['T', "IEM", "T H "; 'M', "BE", ""; 'D', "CEM", "T   "])))))
   | (**************************************************************************
       *******************           elim inductive          *******************
       **************************************************************************)
     true ->
    (match head_id with
    | Nii_not ->
     (match omit with
     | false ->
      (match type_up, type_dn with
      | false, false -> ['T', "HE", ""; 'D', "IEI", " C  "; 'M', "BE", ""]
      | false, true ->
       ['T', "HE", ""; 'M', "IEI", " C  "; 'M', "BE", ""; 'D', "CEI", "T   "]
      | true, false -> ['T', "HE", ""; 'D', "IEI", "TC  "; 'M', "BE", ""]
      | true, true -> ['T', "HE", ""; 'D', "IEI", "TC  "; 'M', "BE", ""])
     | true ->
      (match type_up, type_dn with
      | false, false -> ['T', "HE", ""; 'D', "IEI", "    "; 'M', "BE", ""]
      | false, true ->
       ['T', "HE", ""; 'M', "IEI", "    "; 'M', "BE", ""; 'D', "CEI", "T   "]
      | true, false -> ['T', "HE", ""; 'D', "IEI", "T   "; 'M', "BE", ""]
      | true, true -> ['T', "HE", ""; 'D', "IEI", "T   "; 'M', "BE", ""]))
    | Nii_id _ ->
     (match omit with
     | false ->
      (match type_up, type_dn with
      | false, false -> ['D', "IEI", " CH "; 'M', "BE", ""]
      | false, true -> ['T', "IEI", " CH "; 'M', "BE", ""; 'D', "CEI", "T   "]
      | true, false -> ['D', "IEI", "TCH "; 'M', "BE", ""]
      | true, true -> ['T', "IEI", "TCH "; 'M', "BE", ""; 'D', "CEI", "T   "])
     | true ->
      (match type_up, type_dn with
      | false, false -> ['D', "IEI", "  H "; 'M', "BE", ""]
      | false, true -> ['T', "IEI", "  H "; 'M', "BE", ""; 'D', "CEI", "T   "]
      | true, false -> ['D', "IEI", "T H "; 'M', "BE", ""]
      | true, true -> ['T', "IEI", "T H "; 'M', "BE", ""; 'D', "CEI", "T   "]))))
  | (**************************************************************************
      *******************              fix                  *******************
      **************************************************************************)
    Ni_fix _ ->
   (match type_up || type_dn with
   | false -> ['D', "BF", ""]
   | true -> ['T', "BF", ""; 'D', "CF", "T   "])
  | (**************************************************************************
      *******************             identifier            *******************
      **************************************************************************)
    Ni_id _ ->
   (match type_up || type_dn with
   | false -> ['D', "CID", "   V"]
   | true -> ['D', "CID", "T  V"])
  | (**************************************************************************
      *******************       meta variables              *******************
      **************************************************************************)
    Ni_metavar _ ->
   (match type_up || type_dn with
   | false -> ['D', "CMV", "    "]
   | true -> ['D', "CMV", "T   "])
  | (**************************************************************************
      *******************               misc                *******************
      **************************************************************************)
    _ ->
   (match type_up, type_dn with
   | false, false -> ['D', "BM", ""]
   | false, true -> ['D', "IM", "T   "; 'M', "BM", ""]
   | true, false -> ['T', "BM", ""; 'D', "CM", "T   "]
   | true, true -> ['T', "IM", "T   "; 'T', "BM", ""; 'D', "CM", "T   "]) in
 (**************************************************************************
   **************************************************************************)
 let f1 =
  function
     | ' ' -> 0
     | _ -> 1 in
 let f2 (c, s1, s2) =
  let i =
   match s2 with
   | "I" -> 1
   | s ->
    if String.length s = 4 then
     1000 * f1 (s.[0]) + 100 * f1 (s.[1]) + 10 * f1 (s.[2]) + 1 * f1 (s.[3])
     else 0 in
  c, s1, i in
 let n_f = 
  (type_up, type_dn), List.map f2 n_f in
 try nc_set_n_f n_f nc
 with
 | UserError ("ntdef__nc_set_n_f", _) -> ();;

