Declare ML Module "name_to_ast".
Declare ML Module "xlate".
Declare ML Module "vtp".
Declare ML Module "translate".
Declare ML Module "centaur".

Grammar vernac vernac :=
  goal_cmd [ "Goal" "Cmd" "at" ne_numarg_list($l) "with" tacarg($tac) "." ] ->
        [(GOAL_CMD (NUMBERLIST ($LIST $l)) (TACTIC $tac))]
| goal_cmd_root [ "Goal" "Cmd" "at" "Root" "with" tacarg($tac) "." ] ->
        [(GOAL_CMD (NUMBERLIST) (TACTIC $tac))]
| solve_at[ "Solve" "at" ne_numarg_list($l) "with" tacarg($tac) "." ] ->
        [(SOLVE_AT (NUMBERLIST ($LIST $l)) (TACTIC $tac))]
| solve_at_root[ "Solve" "at" "Root" "with" tacarg($tac) "." ] ->
        [(SOLVE_AT (NUMBERLIST) (TACTIC $tac))]
| kill_proof_at_root[ "Kill" "Proof" "at" "Root" "." ] -> [(KILL_NODE (NUMBERLIST))]
| kill_proof [ "Kill" "Proof" "at" ne_numarg_list($l) "." ] ->
        [(KILL_NODE (NUMBERLIST ($LIST $l)))]
| print_goal_at_reqid [ "print_goal_at_req_id" "." ] ->
       [(PRINT_GOAL_AT_REQ_ID (NUMBERLIST))]
| print_goal_at_reqid2 [ "print_goal_at_req_id" ne_numarg_list($l) "." ] ->
        [(PRINT_GOAL_AT_REQ_ID (NUMBERLIST ($LIST $l))) ]

| print_goal_at [ "Print" "Goal" "at" ne_numarg_list($l) "." ] ->
        [(PRINT_GOAL_AT (NUMBERLIST ($LIST $l))) ]
| print_goal_at_root [ "Print" "Goal" "at" "Root" "." ] -> [(PRINT_GOAL_AT (NUMBERLIST))]
| check_in_goal [ "CHECK_IN_GOAL" numarg($n) comarg($c) "." ] ->
       [(CHECK_IN_GOAL "CHECK" $n $c)]
| eval_in_goal [ "EVAL_IN_GOAL" numarg($n) comarg($c) "." ] ->
       [(CHECK_IN_GOAL "EVAL" $n $c)]
| compute_in_goal [ "COMPUTE_IN_GOAL" numarg($n) comarg($c) "." ] ->
       [(CHECK_IN_GOAL "COMPUTE" $n $c)]
| centaur_reset [ "Centaur" "Reset" identarg($id) "." ] -> [(Centaur_Reset $id)]
| start_pcoq [ "Start" "Pcoq" "Mode" "." ] -> [ (START_PCOQ) ].

(* Maybe we should have syntactic rules to make sur that syntax errors are
   displayed with a readable syntax.  It is not sure, since the error reporting
   procedure changed from V6.1 and does not reprint the command anymore. *)
