(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                            ProgramsExtraction.v                          *)
(****************************************************************************)

Require Export Extraction.

Extract Inductive unit => unit [ "()" ].
Extract Inductive bool => bool [ true false ].
Extract Inductive sumbool => bool [ true false ].

Require Export Programs.

Declare ML Module "prog_extract".

Grammar vernac vernac :=
  imperative_ocaml [ "Write" "Caml" "File" stringarg($file) 
    "[" ne_identarg_list($idl) "]" "." ]
     -> [ (IMPERATIVEEXTRACTION $file (VERNACARGLIST ($LIST $idl))) ]

| initialize [ "Initialize" identarg($id) "with" comarg($c) "." ]
     -> [ (INITIALIZE $id $c) ]
.
