(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(* Certification of Imperative Programs                                     *)
(* Jean-Christophe Fillitre                                                *)
(****************************************************************************)
(*                              prog_tactic.mli                             *)
(****************************************************************************)

(* The main tactic: takes a name N, a program P, creates a goal
 * of name N with the functional specification of P, then apply the Refine
 * tactic with the partial proof term obtained by the translation of
 * P into a functional program.
 *
 * Then an ad-hoc automatic tactic is applied on each subgoal to solve the
 * trivial proof obligations *)

val correctness : string -> ProgAst.program -> Tacmach.tactic option -> unit

(* $Id: prog_tactic.mli,v 1.8 1999/06/29 07:48:22 loiseleu Exp $ *)
