(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(* Certification of Imperative Programs                                     *)
(* Jean-Christophe Fillitre                                                *)
(****************************************************************************)
(*                              prog_typing.mli                             *)
(****************************************************************************)

open Names
open Term

open ProgTypes
open ProgAst
open Prog_env

(* This module realizes type and effect inference *)

val cic_type_v : local_env -> Renamings.t -> CoqAst.t ml_type_v -> type_v

val effect_app : Renamings.t -> local_env
            -> (typing_info,'b) ProgAst.t
            -> (typing_info,constr) arg list
            -> (type_v binder list * type_c) 
             * ((identifier*identifier) list * (identifier*constr) list * bool)
             * type_c

val typed_var : Renamings.t -> local_env -> constr * constr -> variant

val type_of_expression : Renamings.t -> local_env -> constr -> constr

val states : Renamings.t -> local_env -> program -> typed_program

(* $Id: prog_typing.mli,v 1.6 1999/06/29 07:48:22 loiseleu Exp $ *)
