(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(* Certification of Imperative Programs                                     *)
(* Jean-Christophe Fillitre                                                *)
(****************************************************************************)
(*                               tradEnv.mli                                *)
(****************************************************************************)

open Prog_env
open Names
open Term

(* Translation of local programs environments into Coq signatures.
 * It is mainly used to type the pre/post conditions in the good
 * environment *)

(* cci_sign_of: uniquement les objets purement fonctionnels de l'env. *)
val cci_sign_of : Renamings.t -> local_env -> context

(* env. Coq avec seulement les variables X de l'env. *)
val now_sign_of : Renamings.t -> local_env -> context

(* + les variables X@d pour toutes les dates de l'env. *)
val before_sign_of : Renamings.t -> local_env -> context

(* + les variables `avant' X@ *)
val before_after_sign_of : Renamings.t -> local_env -> context
val before_after_result_sign_of : ((identifier * constr) option)
                        -> Renamings.t -> local_env -> context

(* env. des programmes traduits, avec les variables rennomes *)
val trad_sign_of : Renamings.t -> local_env -> context

(* $Id: tradEnv.mli,v 1.17 1999/08/06 20:58:44 herbelin Exp $ *)
